/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.v4.view.animation.PathInterpolatorCompat;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.LottieComposition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class Keyframe<T> {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private final LottieComposition composition;
    T startValue;
    T endValue;
    Interpolator interpolator;
    float startFrame;
    @Nullable
    Float endFrame = null;

    static <T> List<Keyframe<T>> parseKeyframes(JSONArray json, LottieComposition composition, float scale, AnimatableValue<T, ?> animatableValue) {
        if (json.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Keyframe<T>> keyframes = new ArrayList<Keyframe<T>>();
        for (int i = 0; i < json.length(); ++i) {
            keyframes.add(new Keyframe<T>(json.optJSONObject(i), composition, scale, animatableValue));
        }
        Keyframe.setEndFrames(keyframes);
        return keyframes;
    }

    static void setEndFrames(List<? extends Keyframe<?>> keyframes) {
        for (int i = 0; i < keyframes.size() - 1; ++i) {
            keyframes.get((int)i).endFrame = Float.valueOf(keyframes.get((int)(i + 1)).startFrame);
        }
        Keyframe<?> lastKeyframe = keyframes.get(keyframes.size() - 1);
        if (lastKeyframe.startValue == null) {
            keyframes.remove(lastKeyframe);
        }
    }

    public Keyframe(LottieComposition composition, float startFrame, float endFrame) {
        this.composition = composition;
        this.startFrame = startFrame;
        this.endFrame = Float.valueOf(endFrame);
    }

    Keyframe(JSONObject json, LottieComposition composition, float scale, AnimatableValue<T, ?> animatableValue) {
        this.composition = composition;
        PointF cp1 = null;
        PointF cp2 = null;
        if (json.has("t")) {
            boolean hold;
            Object endValueJson;
            this.startFrame = (float)json.optDouble("t", 0.0);
            Object startValueJson = json.opt("s");
            if (startValueJson != null) {
                this.startValue = animatableValue.valueFromObject(startValueJson, scale);
            }
            if ((endValueJson = json.opt("e")) != null) {
                this.endValue = animatableValue.valueFromObject(endValueJson, scale);
            }
            JSONObject cp1Json = json.optJSONObject("o");
            JSONObject cp2Json = json.optJSONObject("i");
            if (cp1Json != null && cp2Json != null) {
                cp1 = JsonUtils.pointFromJsonObject(cp1Json, scale);
                cp2 = JsonUtils.pointFromJsonObject(cp2Json, scale);
            }
            boolean bl = hold = json.optInt("h", 0) == 1;
            if (hold) {
                this.endValue = this.startValue;
                this.interpolator = LINEAR_INTERPOLATOR;
            } else {
                this.interpolator = cp1 != null ? PathInterpolatorCompat.create((float)(cp1.x / scale), (float)(cp1.y / scale), (float)(cp2.x / scale), (float)(cp2.y / scale)) : LINEAR_INTERPOLATOR;
            }
        } else {
            this.startValue = animatableValue.valueFromObject(json, scale);
            this.endValue = this.startValue;
        }
    }

    @FloatRange(from=0.0, to=1.0)
    float getStartProgress() {
        return this.startFrame / this.composition.getDurationFrames();
    }

    @FloatRange(from=0.0, to=1.0)
    float getEndProgress() {
        return this.endFrame == null ? 1.0f : this.endFrame.floatValue() / this.composition.getDurationFrames();
    }

    boolean isStatic() {
        return this.interpolator == null;
    }

    boolean containsProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        return progress >= this.getStartProgress() && progress <= this.getEndProgress();
    }

    public String toString() {
        return "Keyframe{startValue=" + this.startValue + ", endValue=" + this.endValue + ", startFrame=" + this.startFrame + ", endFrame=" + this.endFrame + ", interpolator=" + this.interpolator + '}';
    }
}

