/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.support.annotation.FloatRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.LongSparseArray;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BitmapCanvas;
import com.airbnb.lottie.CanvasPool;
import com.airbnb.lottie.CircleShape;
import com.airbnb.lottie.EllipseLayer;
import com.airbnb.lottie.FloatKeyframeAnimation;
import com.airbnb.lottie.GroupLayerView;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.Mask;
import com.airbnb.lottie.MaskKeyframeAnimation;
import com.airbnb.lottie.PolystarLayer;
import com.airbnb.lottie.PolystarShape;
import com.airbnb.lottie.RectLayer;
import com.airbnb.lottie.RectangleShape;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeGroup;
import com.airbnb.lottie.ShapeLayerView;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class LayerView
extends AnimatableLayer {
    private static final int SAVE_FLAGS = 18;
    private MaskKeyframeAnimation mask;
    private LayerView matteLayer;
    private final PorterDuffXfermode DST_OUT = new PorterDuffXfermode(PorterDuff.Mode.DST_OUT);
    private final PorterDuffXfermode DST_IN = new PorterDuffXfermode(PorterDuff.Mode.DST_IN);
    private final RectF rect = new RectF();
    private final List<LayerView> transformLayers = new ArrayList<LayerView>();
    private final Paint mainCanvasPaint = new Paint();
    private final Paint mattePaint = new Paint(1);
    private final Paint maskPaint = new Paint(1);
    private final Paint imagePaint = new Paint(3);
    private final Layer layerModel;
    private final LottieComposition composition;
    private final CanvasPool canvasPool;
    @Nullable
    private LayerView parentLayer;
    private int precompWidth;
    private int precompHeight;

    LayerView(Layer layerModel, LottieComposition composition, Drawable.Callback callback, CanvasPool canvasPool) {
        super(callback);
        this.layerModel = layerModel;
        this.composition = composition;
        this.canvasPool = canvasPool;
        this.setBounds(composition.getBounds());
        if (layerModel.getMatteType() == Layer.MatteType.Invert) {
            this.mattePaint.setXfermode((Xfermode)this.DST_OUT);
        } else {
            this.mattePaint.setXfermode((Xfermode)this.DST_IN);
        }
        this.setupForModel();
    }

    private void setupForModel() {
        this.setBackgroundColor(this.layerModel.getSolidColor());
        this.setBounds(0, 0, this.layerModel.getSolidWidth(), this.layerModel.getSolidHeight());
        this.setTransform(this.layerModel.getTransform().createAnimation());
        this.setupInOutAnimations();
        switch (this.layerModel.getLayerType()) {
            case Shape: {
                this.setupShapeLayer();
                break;
            }
            case PreComp: {
                this.setupPreCompLayer();
            }
        }
        if (this.layerModel.getMasks() != null && !this.layerModel.getMasks().isEmpty()) {
            this.setMask(new MaskKeyframeAnimation(this.layerModel.getMasks()));
        }
        LongSparseArray layerMap = new LongSparseArray();
        for (AnimatableLayer layer : this.layers) {
            if (!(layer instanceof LayerView)) continue;
            layerMap.put(((LayerView)layer).getId(), (Object)((LayerView)layer));
            LayerView matteLayer = ((LayerView)layer).matteLayer;
            if (matteLayer == null) continue;
            layerMap.put(matteLayer.getId(), (Object)matteLayer);
        }
        for (AnimatableLayer layer : this.layers) {
            LayerView matteLayer;
            if (!(layer instanceof LayerView)) continue;
            long parentId = ((LayerView)layer).getLayerModel().getParentId();
            LayerView parentLayer = (LayerView)((Object)layerMap.get(parentId));
            if (parentLayer != null) {
                ((LayerView)layer).setParentLayer(parentLayer);
            }
            if ((matteLayer = ((LayerView)layer).matteLayer) == null || (parentLayer = (LayerView)((Object)layerMap.get(parentId = matteLayer.getLayerModel().getParentId()))) == null) continue;
            matteLayer.setParentLayer(parentLayer);
        }
    }

    private void setupShapeLayer() {
        ArrayList<Object> reversedItems = new ArrayList<Object>(this.layerModel.getShapes());
        Collections.reverse(reversedItems);
        AnimatableTransform currentTransform = null;
        ShapeTrimPath currentTrim = null;
        ShapeFill currentFill = null;
        ShapeStroke currentStroke = null;
        for (int i = 0; i < reversedItems.size(); ++i) {
            AnimatableLayer shapeLayer;
            Object item = reversedItems.get(i);
            if (item instanceof ShapeGroup) {
                GroupLayerView groupLayer = new GroupLayerView((ShapeGroup)item, currentFill, currentStroke, currentTrim, currentTransform, this.getCallback());
                this.addLayer(groupLayer);
                continue;
            }
            if (item instanceof AnimatableTransform) {
                currentTransform = (AnimatableTransform)item;
                continue;
            }
            if (item instanceof ShapeFill) {
                currentFill = (ShapeFill)item;
                continue;
            }
            if (item instanceof ShapeTrimPath) {
                currentTrim = (ShapeTrimPath)item;
                continue;
            }
            if (item instanceof ShapeStroke) {
                currentStroke = (ShapeStroke)item;
                continue;
            }
            if (item instanceof ShapePath) {
                ShapePath shapePath = (ShapePath)item;
                shapeLayer = new ShapeLayerView(shapePath, currentFill, currentStroke, currentTrim, AnimatableTransform.Factory.newInstance(this.composition), this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (item instanceof RectangleShape) {
                RectangleShape shapeRect = (RectangleShape)item;
                shapeLayer = new RectLayer(shapeRect, currentFill, currentStroke, currentTrim, AnimatableTransform.Factory.newInstance(this.composition), this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (item instanceof CircleShape) {
                CircleShape shapeCircle = (CircleShape)item;
                shapeLayer = new EllipseLayer(shapeCircle, currentFill, currentStroke, currentTrim, AnimatableTransform.Factory.newInstance(this.composition), this.getCallback());
                this.addLayer(shapeLayer);
                continue;
            }
            if (!(item instanceof PolystarShape)) continue;
            PolystarShape polystarShape = (PolystarShape)item;
            shapeLayer = new PolystarLayer(polystarShape, currentFill, currentStroke, currentTrim, AnimatableTransform.Factory.newInstance(this.composition), this.getCallback());
            this.addLayer(shapeLayer);
        }
    }

    private void setupPreCompLayer() {
        List<Layer> precompLayers = this.composition.getPrecomps(this.layerModel.getRefId());
        if (precompLayers == null) {
            return;
        }
        LayerView mattedLayer = null;
        for (int i = precompLayers.size() - 1; i >= 0; --i) {
            Layer layer = precompLayers.get(i);
            LayerView layerView = new LayerView(layer, this.composition, this.getCallback(), this.canvasPool);
            layerView.setPrecompSize(this.layerModel.getPreCompWidth(), this.layerModel.getPreCompHeight());
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layerView);
                mattedLayer = null;
                continue;
            }
            this.addLayer(layerView);
            if (layer.getMatteType() == Layer.MatteType.Add) {
                mattedLayer = layerView;
                continue;
            }
            if (layer.getMatteType() != Layer.MatteType.Invert) continue;
            mattedLayer = layerView;
        }
    }

    private void setupInOutAnimations() {
        if (!this.layerModel.getInOutKeyframes().isEmpty()) {
            FloatKeyframeAnimation inOutAnimation = new FloatKeyframeAnimation(this.layerModel.getInOutKeyframes());
            inOutAnimation.setIsDiscrete();
            inOutAnimation.addUpdateListener(new BaseKeyframeAnimation.AnimationListener<Float>(){

                @Override
                public void onValueChanged(Float value) {
                    LayerView.this.setVisible(value.floatValue() == 1.0f, false);
                }
            });
            this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f, false);
            this.addAnimation(inOutAnimation);
        } else {
            this.setVisible(true, false);
        }
    }

    Layer getLayerModel() {
        return this.layerModel;
    }

    void setParentLayer(@Nullable LayerView parentLayer) {
        this.parentLayer = parentLayer;
    }

    @Nullable
    private LayerView getParentLayer() {
        return this.parentLayer;
    }

    private void setPrecompSize(int width, int height) {
        this.precompWidth = width;
        this.precompHeight = height;
    }

    private void setMask(MaskKeyframeAnimation mask) {
        this.mask = mask;
        for (BaseKeyframeAnimation<?, Path> animation : mask.getMaskAnimations()) {
            this.addAnimation(animation);
            animation.addUpdateListener(this.pathChangedListener);
        }
    }

    void setMatteLayer(LayerView matteLayer) {
        this.matteLayer = matteLayer;
    }

    @Override
    public void draw(@NonNull Canvas canvas) {
        if (!this.isVisible() || this.mainCanvasPaint.getAlpha() == 0) {
            return;
        }
        this.transformLayers.clear();
        for (LayerView parent = this.parentLayer; parent != null; parent = parent.getParentLayer()) {
            this.transformLayers.add(parent);
        }
        if (!this.hasMasks() && !this.hasMatte()) {
            int mainCanvasCount = this.saveCanvas(canvas);
            if (this.precompWidth != 0 || this.precompHeight != 0) {
                canvas.clipRect(0, 0, this.precompWidth, this.precompHeight);
            }
            for (int i = this.transformLayers.size() - 1; i >= 0; --i) {
                LayerView layer = this.transformLayers.get(i);
                this.applyTransformForLayer(canvas, layer);
            }
            this.drawImageIfNeeded(canvas);
            super.draw(canvas);
            canvas.restoreToCount(mainCanvasCount);
            return;
        }
        BitmapCanvas bitmapCanvas = this.canvasPool.acquire(canvas.getWidth(), canvas.getHeight(), Bitmap.Config.ARGB_8888);
        bitmapCanvas.save();
        this.drawImageIfNeeded(bitmapCanvas);
        for (int i = this.transformLayers.size() - 1; i >= 0; --i) {
            LayerView layer = this.transformLayers.get(i);
            this.applyTransformForLayer(bitmapCanvas, layer);
        }
        super.draw(bitmapCanvas);
        this.rect.set(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        if (this.hasMasks()) {
            List<Mask> masks = this.mask.getMasks();
            List<BaseKeyframeAnimation<?, Path>> maskAnimations = this.mask.getMaskAnimations();
            for (int i = 0; i < masks.size(); ++i) {
                this.applyMask(bitmapCanvas, masks.get(i), maskAnimations.get(i));
            }
        }
        bitmapCanvas.restore();
        if (this.hasMatte()) {
            bitmapCanvas.saveLayer(this.rect, this.mattePaint, 18);
            this.matteLayer.draw(bitmapCanvas);
            bitmapCanvas.restore();
        }
        if (this.precompWidth != 0 || this.precompHeight != 0) {
            canvas.clipRect(0, 0, this.precompWidth, this.precompHeight);
        }
        canvas.drawBitmap(bitmapCanvas.getBitmap(), 0.0f, 0.0f, null);
        this.canvasPool.release(bitmapCanvas);
    }

    private void applyMask(BitmapCanvas canvas, Mask mask, BaseKeyframeAnimation<?, Path> maskAnimation) {
        switch (mask.getMaskMode()) {
            case MaskModeSubtract: {
                this.maskPaint.setXfermode((Xfermode)this.DST_OUT);
                break;
            }
            default: {
                this.maskPaint.setXfermode((Xfermode)this.DST_IN);
            }
        }
        canvas.saveLayer(this.rect, this.maskPaint, 18);
        for (int i = this.transformLayers.size() - 1; i >= 0; --i) {
            LayerView layer = this.transformLayers.get(i);
            this.applyTransformForLayer(canvas, layer);
        }
        this.applyTransformForLayer(canvas, this);
        canvas.drawPath(maskAnimation.getValue(), this.mainCanvasPaint);
        canvas.restore();
    }

    private void drawImageIfNeeded(Canvas canvas) {
        if (!this.composition.hasImages()) {
            return;
        }
        String refId = this.layerModel.getRefId();
        Bitmap bitmap = this.getLottieDrawable().getImageAsset(refId);
        if (bitmap == null) {
            return;
        }
        canvas.save();
        this.applyTransformForLayer(canvas, this);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, this.imagePaint);
        canvas.restore();
    }

    boolean hasMatte() {
        return this.matteLayer != null;
    }

    boolean hasMasks() {
        return this.mask != null && !this.mask.getMaskAnimations().isEmpty();
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        super.setProgress(progress *= this.layerModel.getTimeStretch());
        if (this.matteLayer != null) {
            this.matteLayer.setProgress(progress);
        }
    }

    long getId() {
        return this.layerModel.getId();
    }

    public String toString() {
        return this.layerModel.toString();
    }
}

