/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.Utils;
import org.json.JSONArray;
import org.json.JSONObject;

class PathKeyframe
extends Keyframe<PointF> {
    @Nullable
    private Path path;

    PathKeyframe(JSONObject json, LottieComposition composition, AnimatableValue<PointF, ?> animatableValue) {
        super(json, composition, composition.getScale(), animatableValue);
        PointF cp1 = null;
        PointF cp2 = null;
        JSONArray tiJson = json.optJSONArray("ti");
        JSONArray toJson = json.optJSONArray("to");
        if (tiJson != null && toJson != null) {
            cp1 = JsonUtils.pointFromJsonArray(toJson, composition.getScale());
            cp2 = JsonUtils.pointFromJsonArray(tiJson, composition.getScale());
        }
        if (this.endValue != null && !((PointF)this.startValue).equals(this.endValue)) {
            this.path = Utils.createPath((PointF)this.startValue, (PointF)this.endValue, cp1, cp2);
        }
    }

    @Nullable
    Path getPath() {
        return this.path;
    }
}

