/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableLayer;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.ScaleXY;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeLayer;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import java.util.ArrayList;

class ShapeLayerView
extends AnimatableLayer {
    @Nullable
    private ShapeLayer fillLayer;
    @Nullable
    private ShapeLayer strokeLayer;

    ShapeLayerView(ShapePath shape, @Nullable ShapeFill fill, @Nullable ShapeStroke stroke, @Nullable ShapeTrimPath trim, AnimatableTransform transformModel, Drawable.Callback callback) {
        super(callback);
        this.setTransform(transformModel.createAnimation());
        if (fill != null) {
            this.fillLayer = new ShapeLayer(this.getCallback());
            this.fillLayer.setPath(shape.getShapePath().createAnimation());
            this.fillLayer.setColor((KeyframeAnimation<Integer>)fill.getColor().createAnimation());
            this.fillLayer.setShapeOpacity((KeyframeAnimation<Integer>)fill.getOpacity().createAnimation());
            this.fillLayer.setTransformOpacity((KeyframeAnimation<Integer>)transformModel.getOpacity().createAnimation());
            this.fillLayer.setScale((KeyframeAnimation<ScaleXY>)transformModel.getScale().createAnimation());
            if (trim != null) {
                this.fillLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(this.fillLayer);
        }
        if (stroke != null) {
            this.strokeLayer = new ShapeLayer(this.getCallback());
            this.strokeLayer.setIsStroke();
            this.strokeLayer.setPath(shape.getShapePath().createAnimation());
            this.strokeLayer.setColor((KeyframeAnimation<Integer>)stroke.getColor().createAnimation());
            this.strokeLayer.setShapeOpacity((KeyframeAnimation<Integer>)stroke.getOpacity().createAnimation());
            this.strokeLayer.setTransformOpacity((KeyframeAnimation<Integer>)transformModel.getOpacity().createAnimation());
            this.strokeLayer.setLineWidth((KeyframeAnimation<Float>)stroke.getWidth().createAnimation());
            if (!stroke.getLineDashPattern().isEmpty()) {
                ArrayList dashPatternAnimations = new ArrayList(stroke.getLineDashPattern().size());
                for (AnimatableFloatValue dashPattern : stroke.getLineDashPattern()) {
                    dashPatternAnimations.add(dashPattern.createAnimation());
                }
                this.strokeLayer.setDashPattern(dashPatternAnimations, stroke.getDashOffset().createAnimation());
            }
            this.strokeLayer.setLineCapType(stroke.getCapType());
            this.strokeLayer.setLineJoinType(stroke.getJoinType());
            this.strokeLayer.setScale((KeyframeAnimation<ScaleXY>)transformModel.getScale().createAnimation());
            if (trim != null) {
                this.strokeLayer.setTrimPath((KeyframeAnimation<Float>)trim.getStart().createAnimation(), (KeyframeAnimation<Float>)trim.getEnd().createAnimation(), (KeyframeAnimation<Float>)trim.getOffset().createAnimation());
            }
            this.addLayer(this.strokeLayer);
        }
    }

    @Override
    public void setAlpha(int alpha) {
        super.setAlpha(alpha);
        if (this.fillLayer != null) {
            this.fillLayer.setAlpha(alpha);
        }
        if (this.strokeLayer != null) {
            this.strokeLayer.setAlpha(alpha);
        }
    }
}

