/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.support.annotation.CallSuper;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.util.Log;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.CompositionLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.DrawingContent;
import com.airbnb.lottie.FloatKeyframeAnimation;
import com.airbnb.lottie.ImageLayer;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.Mask;
import com.airbnb.lottie.MaskKeyframeAnimation;
import com.airbnb.lottie.NullLayer;
import com.airbnb.lottie.ShapeLayer;
import com.airbnb.lottie.SolidLayer;
import com.airbnb.lottie.StaticKeyframeAnimation;
import com.airbnb.lottie.TransformKeyframeAnimation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

abstract class BaseLayer
implements DrawingContent,
BaseKeyframeAnimation.AnimationListener {
    private static final int SAVE_FLAGS = 19;
    private final Path path = new Path();
    private final Matrix matrix = new Matrix();
    private final Paint contentPaint = new Paint(1);
    private final Paint maskPaint = new Paint(1);
    private final Paint mattePaint = new Paint(1);
    private final Paint clearPaint = new Paint();
    private final RectF rect = new RectF();
    private final RectF maskBoundsRect = new RectF();
    private final RectF matteBoundsRect = new RectF();
    private final RectF tempMaskBoundsRect = new RectF();
    final Matrix boundsMatrix = new Matrix();
    final LottieDrawable lottieDrawable;
    final Layer layerModel;
    @Nullable
    private MaskKeyframeAnimation mask;
    @Nullable
    private BaseLayer matteLayer;
    @Nullable
    private BaseLayer parentLayer;
    private List<BaseLayer> parentLayers;
    private final List<BaseKeyframeAnimation<?, ?>> animations = new ArrayList();
    final TransformKeyframeAnimation transform;
    private boolean visible = true;

    static BaseLayer forModel(Layer layerModel, LottieDrawable drawable, LottieComposition composition) {
        switch (layerModel.getLayerType()) {
            case Shape: {
                return new ShapeLayer(drawable, layerModel);
            }
            case PreComp: {
                return new CompositionLayer(drawable, layerModel, composition.getPrecomps(layerModel.getRefId()), composition);
            }
            case Solid: {
                return new SolidLayer(drawable, layerModel);
            }
            case Image: {
                return new ImageLayer(drawable, layerModel, composition.getDpScale());
            }
            case Null: {
                return new NullLayer(drawable, layerModel);
            }
        }
        Log.w((String)"LOTTIE", (String)("Unknown layer type " + (Object)((Object)layerModel.getLayerType())));
        return new NullLayer(drawable, layerModel);
    }

    BaseLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        this.lottieDrawable = lottieDrawable;
        this.layerModel = layerModel;
        this.clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.maskPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        if (layerModel.getMatteType() == Layer.MatteType.Invert) {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
        } else {
            this.mattePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        }
        this.transform = layerModel.getTransform().createAnimation();
        this.transform.addListener(this);
        this.transform.addAnimationsToLayer(this);
        if (layerModel.getMasks() != null && !layerModel.getMasks().isEmpty()) {
            this.mask = new MaskKeyframeAnimation(layerModel.getMasks());
            for (BaseKeyframeAnimation<?, Path> animation : this.mask.getMaskAnimations()) {
                this.addAnimation(animation);
                animation.addUpdateListener(this);
            }
        }
        this.setupInOutAnimations();
    }

    @Override
    public void onValueChanged() {
        this.invalidateSelf();
    }

    Layer getLayerModel() {
        return this.layerModel;
    }

    void setMatteLayer(@Nullable BaseLayer matteLayer) {
        this.matteLayer = matteLayer;
    }

    boolean hasMatteOnThisLayer() {
        return this.matteLayer != null;
    }

    void setParentLayer(@Nullable BaseLayer parentLayer) {
        this.parentLayer = parentLayer;
    }

    private void setupInOutAnimations() {
        if (!this.layerModel.getInOutKeyframes().isEmpty()) {
            final FloatKeyframeAnimation inOutAnimation = new FloatKeyframeAnimation(this.layerModel.getInOutKeyframes());
            inOutAnimation.setIsDiscrete();
            inOutAnimation.addUpdateListener(new BaseKeyframeAnimation.AnimationListener(){

                @Override
                public void onValueChanged() {
                    BaseLayer.this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f);
                }
            });
            this.setVisible(((Float)inOutAnimation.getValue()).floatValue() == 1.0f);
            this.addAnimation(inOutAnimation);
        } else {
            this.setVisible(true);
        }
    }

    private void invalidateSelf() {
        this.lottieDrawable.invalidateSelf();
    }

    void addAnimation(BaseKeyframeAnimation<?, ?> newAnimation) {
        if (!(newAnimation instanceof StaticKeyframeAnimation)) {
            this.animations.add(newAnimation);
        }
    }

    @Override
    @CallSuper
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        this.boundsMatrix.set(parentMatrix);
        this.boundsMatrix.preConcat(this.transform.getMatrix());
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        if (!this.visible) {
            return;
        }
        this.buildParentLayerListIfNeeded();
        this.matrix.reset();
        this.matrix.set(parentMatrix);
        for (int i = this.parentLayers.size() - 1; i >= 0; --i) {
            this.matrix.preConcat(this.parentLayers.get((int)i).transform.getMatrix());
        }
        int alpha = (int)((float)parentAlpha / 255.0f * (float)this.transform.getOpacity().getValue().intValue() / 100.0f * 255.0f);
        if (!this.hasMatteOnThisLayer() && !this.hasMasksOnThisLayer()) {
            this.matrix.preConcat(this.transform.getMatrix());
            this.drawLayer(canvas, this.matrix, alpha);
            return;
        }
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        this.getBounds(this.rect, this.matrix);
        this.intersectBoundsWithMatte(this.rect, this.matrix);
        this.matrix.preConcat(this.transform.getMatrix());
        this.intersectBoundsWithMask(this.rect, this.matrix);
        this.rect.set(0.0f, 0.0f, (float)canvas.getWidth(), (float)canvas.getHeight());
        canvas.saveLayer(this.rect, this.contentPaint, 31);
        this.clearCanvas(canvas);
        this.drawLayer(canvas, this.matrix, alpha);
        if (this.hasMasksOnThisLayer()) {
            this.applyMasks(canvas, this.matrix);
        }
        if (this.hasMatteOnThisLayer()) {
            canvas.saveLayer(this.rect, this.mattePaint, 19);
            this.clearCanvas(canvas);
            this.matteLayer.draw(canvas, parentMatrix, alpha);
            canvas.restore();
        }
        canvas.restore();
    }

    private void clearCanvas(Canvas canvas) {
        canvas.drawRect(this.rect.left - 1.0f, this.rect.top - 1.0f, this.rect.right + 1.0f, this.rect.bottom + 1.0f, this.clearPaint);
    }

    private void intersectBoundsWithMask(RectF rect, Matrix matrix) {
        this.maskBoundsRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        if (!this.hasMasksOnThisLayer()) {
            return;
        }
        int size = this.mask.getMasks().size();
        for (int i = 0; i < size; ++i) {
            Mask mask = this.mask.getMasks().get(i);
            BaseKeyframeAnimation<?, Path> maskAnimation = this.mask.getMaskAnimations().get(i);
            Path maskPath = maskAnimation.getValue();
            this.path.set(maskPath);
            this.path.transform(matrix);
            switch (mask.getMaskMode()) {
                case MaskModeSubtract: {
                    return;
                }
            }
            this.path.computeBounds(this.tempMaskBoundsRect, false);
            if (i == 0) {
                this.maskBoundsRect.set(this.tempMaskBoundsRect);
                continue;
            }
            this.maskBoundsRect.set(Math.min(this.maskBoundsRect.left, this.tempMaskBoundsRect.left), Math.min(this.maskBoundsRect.top, this.tempMaskBoundsRect.top), Math.max(this.maskBoundsRect.right, this.tempMaskBoundsRect.right), Math.max(this.maskBoundsRect.bottom, this.tempMaskBoundsRect.bottom));
        }
        rect.set(Math.max(rect.left, this.maskBoundsRect.left), Math.max(rect.top, this.maskBoundsRect.top), Math.min(rect.right, this.maskBoundsRect.right), Math.min(rect.bottom, this.maskBoundsRect.bottom));
    }

    private void intersectBoundsWithMatte(RectF rect, Matrix matrix) {
        if (!this.hasMatteOnThisLayer()) {
            return;
        }
        if (this.layerModel.getMatteType() == Layer.MatteType.Invert) {
            return;
        }
        this.matteLayer.getBounds(this.matteBoundsRect, matrix);
        rect.set(Math.max(rect.left, this.matteBoundsRect.left), Math.max(rect.top, this.matteBoundsRect.top), Math.min(rect.right, this.matteBoundsRect.right), Math.min(rect.bottom, this.matteBoundsRect.bottom));
    }

    abstract void drawLayer(Canvas var1, Matrix var2, int var3);

    private void applyMasks(Canvas canvas, Matrix matrix) {
        canvas.saveLayer(this.rect, this.maskPaint, 19);
        this.clearCanvas(canvas);
        int size = this.mask.getMasks().size();
        for (int i = 0; i < size; ++i) {
            Mask mask = this.mask.getMasks().get(i);
            BaseKeyframeAnimation<?, Path> maskAnimation = this.mask.getMaskAnimations().get(i);
            Path maskPath = maskAnimation.getValue();
            this.path.set(maskPath);
            this.path.transform(matrix);
            switch (mask.getMaskMode()) {
                case MaskModeSubtract: {
                    this.path.setFillType(Path.FillType.INVERSE_WINDING);
                    break;
                }
                default: {
                    this.path.setFillType(Path.FillType.WINDING);
                }
            }
            canvas.drawPath(this.path, this.contentPaint);
        }
        canvas.restore();
    }

    boolean hasMasksOnThisLayer() {
        return this.mask != null && !this.mask.getMaskAnimations().isEmpty();
    }

    private void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            this.invalidateSelf();
        }
    }

    void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.matteLayer != null) {
            this.matteLayer.setProgress(progress);
        }
        for (int i = 0; i < this.animations.size(); ++i) {
            this.animations.get(i).setProgress(progress);
        }
    }

    private void buildParentLayerListIfNeeded() {
        if (this.parentLayers != null) {
            return;
        }
        if (this.parentLayer == null) {
            this.parentLayers = Collections.emptyList();
            return;
        }
        this.parentLayers = new ArrayList<BaseLayer>();
        BaseLayer layer = this.parentLayer;
        while (layer != null) {
            this.parentLayers.add(layer);
            layer = layer.parentLayer;
        }
    }

    @Override
    public String getName() {
        return this.layerModel.getName();
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
    }
}

