/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.PointF;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatablePathValue;
import com.airbnb.lottie.AnimatablePointValue;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONObject;

class RectangleShape {
    private final String name;
    private final AnimatableValue<PointF> position;
    private final AnimatablePointValue size;
    private final AnimatableFloatValue cornerRadius;

    private RectangleShape(String name, AnimatableValue<PointF> position, AnimatablePointValue size, AnimatableFloatValue cornerRadius) {
        this.name = name;
        this.position = position;
        this.size = size;
        this.cornerRadius = cornerRadius;
    }

    String getName() {
        return this.name;
    }

    AnimatableFloatValue getCornerRadius() {
        return this.cornerRadius;
    }

    AnimatablePointValue getSize() {
        return this.size;
    }

    AnimatableValue<PointF> getPosition() {
        return this.position;
    }

    public String toString() {
        return "RectangleShape{cornerRadius=" + this.cornerRadius.getInitialValue() + ", position=" + this.position + ", size=" + this.size + '}';
    }

    static class Factory {
        private Factory() {
        }

        static RectangleShape newInstance(JSONObject json, LottieComposition composition) {
            return new RectangleShape(json.optString("nm"), AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(json.optJSONObject("p"), composition), AnimatablePointValue.Factory.newInstance(json.optJSONObject("s"), composition), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("r"), composition));
        }
    }
}

