/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import android.util.Log;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.CircleShape;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.DrawingContent;
import com.airbnb.lottie.EllipseContent;
import com.airbnb.lottie.FillContent;
import com.airbnb.lottie.GradientFill;
import com.airbnb.lottie.GradientFillContent;
import com.airbnb.lottie.GradientStroke;
import com.airbnb.lottie.GradientStrokeContent;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.MergePaths;
import com.airbnb.lottie.MergePathsContent;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.PolystarContent;
import com.airbnb.lottie.PolystarShape;
import com.airbnb.lottie.RectangleContent;
import com.airbnb.lottie.RectangleShape;
import com.airbnb.lottie.ShapeContent;
import com.airbnb.lottie.ShapeFill;
import com.airbnb.lottie.ShapeGroup;
import com.airbnb.lottie.ShapePath;
import com.airbnb.lottie.ShapeStroke;
import com.airbnb.lottie.ShapeTrimPath;
import com.airbnb.lottie.StrokeContent;
import com.airbnb.lottie.TransformKeyframeAnimation;
import com.airbnb.lottie.TrimPathContent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class ContentGroup
implements DrawingContent,
PathContent,
BaseKeyframeAnimation.AnimationListener {
    private static final String TAG = ContentGroup.class.getSimpleName();
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final RectF rect = new RectF();
    private final String name;
    private final List<Content> contents = new ArrayList<Content>();
    private final LottieDrawable lottieDrawable;
    @Nullable
    private List<PathContent> pathContents;
    @Nullable
    private TransformKeyframeAnimation transformAnimation;

    ContentGroup(LottieDrawable lottieDrawable, BaseLayer layer, ShapeGroup shapeGroup) {
        Content content;
        this.name = shapeGroup.getName();
        this.lottieDrawable = lottieDrawable;
        List<Object> items = shapeGroup.getItems();
        if (items.isEmpty()) {
            return;
        }
        Object potentialTransform = items.get(items.size() - 1);
        if (potentialTransform instanceof AnimatableTransform) {
            this.transformAnimation = ((AnimatableTransform)potentialTransform).createAnimation();
            this.transformAnimation.addAnimationsToLayer(layer);
            this.transformAnimation.addListener(this);
        }
        for (int i = 0; i < items.size(); ++i) {
            Object item = items.get(i);
            if (item instanceof ShapeFill) {
                this.contents.add(new FillContent(lottieDrawable, layer, (ShapeFill)item));
                continue;
            }
            if (item instanceof GradientFill) {
                this.contents.add(new GradientFillContent(lottieDrawable, layer, (GradientFill)item));
                continue;
            }
            if (item instanceof ShapeStroke) {
                this.contents.add(new StrokeContent(lottieDrawable, layer, (ShapeStroke)item));
                continue;
            }
            if (item instanceof GradientStroke) {
                this.contents.add(new GradientStrokeContent(lottieDrawable, layer, (GradientStroke)item));
                continue;
            }
            if (item instanceof ShapeGroup) {
                this.contents.add(new ContentGroup(lottieDrawable, layer, (ShapeGroup)item));
                continue;
            }
            if (item instanceof RectangleShape) {
                this.contents.add(new RectangleContent(lottieDrawable, layer, (RectangleShape)item));
                continue;
            }
            if (item instanceof CircleShape) {
                this.contents.add(new EllipseContent(lottieDrawable, layer, (CircleShape)item));
                continue;
            }
            if (item instanceof ShapePath) {
                this.contents.add(new ShapeContent(lottieDrawable, layer, (ShapePath)item));
                continue;
            }
            if (item instanceof PolystarShape) {
                this.contents.add(new PolystarContent(lottieDrawable, layer, (PolystarShape)item));
                continue;
            }
            if (item instanceof ShapeTrimPath) {
                this.contents.add(new TrimPathContent(layer, (ShapeTrimPath)item));
                continue;
            }
            if (!(item instanceof MergePaths)) continue;
            if (lottieDrawable.enableMergePathsForKitKatAndAbove()) {
                this.contents.add(new MergePathsContent((MergePaths)item));
                continue;
            }
            Log.w((String)TAG, (String)"Animation contains merge paths but they are disabled.");
        }
        ArrayList<Content> contentsToRemove = new ArrayList<Content>();
        MergePathsContent currentMergePathsContent = null;
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            content = this.contents.get(i);
            if (content instanceof MergePathsContent) {
                currentMergePathsContent = (MergePathsContent)content;
            }
            if (currentMergePathsContent == null || content == currentMergePathsContent) continue;
            currentMergePathsContent.addContentIfNeeded(content);
            contentsToRemove.add(content);
        }
        Iterator<Content> it = this.contents.iterator();
        while (it.hasNext()) {
            content = it.next();
            if (!contentsToRemove.contains(content)) continue;
            it.remove();
        }
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        for (int i = 0; i < this.contents.size(); ++i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            DrawingContent drawingContent = (DrawingContent)content;
            if (contentName == null || contentName.equals(content.getName())) {
                drawingContent.addColorFilter(layerName, null, colorFilter);
                continue;
            }
            drawingContent.addColorFilter(layerName, contentName, colorFilter);
        }
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        ArrayList<Content> myContentsBefore = new ArrayList<Content>(contentsBefore.size() + this.contents.size());
        myContentsBefore.addAll(contentsBefore);
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            content.setContents(myContentsBefore, this.contents.subList(0, i));
            myContentsBefore.add(content);
        }
    }

    List<PathContent> getPathList() {
        if (this.pathContents == null) {
            this.pathContents = new ArrayList<PathContent>();
            for (int i = 0; i < this.contents.size(); ++i) {
                Content content = this.contents.get(i);
                if (!(content instanceof PathContent)) continue;
                this.pathContents.add((PathContent)content);
            }
        }
        return this.pathContents;
    }

    Matrix getTransformationMatrix() {
        if (this.transformAnimation != null) {
            return this.transformAnimation.getMatrix();
        }
        this.matrix.reset();
        return this.matrix;
    }

    @Override
    public Path getPath() {
        this.matrix.reset();
        if (this.transformAnimation != null) {
            this.matrix.set(this.transformAnimation.getMatrix());
        }
        this.path.reset();
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof PathContent)) continue;
            this.path.addPath(((PathContent)content).getPath(), this.matrix);
        }
        return this.path;
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        int alpha;
        this.matrix.set(parentMatrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
            alpha = (int)((float)this.transformAnimation.getOpacity().getValue().intValue() / 100.0f * (float)parentAlpha / 255.0f * 255.0f);
        } else {
            alpha = parentAlpha;
        }
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            ((DrawingContent)content).draw(canvas, this.matrix, alpha);
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        this.matrix.set(parentMatrix);
        if (this.transformAnimation != null) {
            this.matrix.preConcat(this.transformAnimation.getMatrix());
        }
        this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
        for (int i = this.contents.size() - 1; i >= 0; --i) {
            Content content = this.contents.get(i);
            if (!(content instanceof DrawingContent)) continue;
            ((DrawingContent)content).getBounds(this.rect, this.matrix);
            if (outBounds.isEmpty()) {
                outBounds.set(this.rect);
                continue;
            }
            outBounds.set(Math.min(outBounds.left, this.rect.left), Math.min(outBounds.top, this.rect.top), Math.max(outBounds.right, this.rect.right), Math.max(outBounds.bottom, this.rect.bottom));
        }
    }
}

