/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.LottieComposition;
import org.json.JSONObject;

class ShapeTrimPath {
    private final String name;
    private final Type type;
    private final AnimatableFloatValue start;
    private final AnimatableFloatValue end;
    private final AnimatableFloatValue offset;

    private ShapeTrimPath(String name, Type type, AnimatableFloatValue start, AnimatableFloatValue end, AnimatableFloatValue offset) {
        this.name = name;
        this.type = type;
        this.start = start;
        this.end = end;
        this.offset = offset;
    }

    String getName() {
        return this.name;
    }

    Type getType() {
        return this.type;
    }

    AnimatableFloatValue getEnd() {
        return this.end;
    }

    AnimatableFloatValue getStart() {
        return this.start;
    }

    AnimatableFloatValue getOffset() {
        return this.offset;
    }

    public String toString() {
        return "Trim Path: {start: " + this.start + ", end: " + this.end + ", offset: " + this.offset + "}";
    }

    static class Factory {
        private Factory() {
        }

        static ShapeTrimPath newInstance(JSONObject json, LottieComposition composition) {
            return new ShapeTrimPath(json.optString("nm"), Type.forId(json.optInt("m", 1)), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("s"), composition, false), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("e"), composition, false), AnimatableFloatValue.Factory.newInstance(json.optJSONObject("o"), composition, false));
        }
    }

    static enum Type {
        Simultaneously,
        Individually;


        static Type forId(int id) {
            switch (id) {
                case 1: {
                    return Simultaneously;
                }
                case 2: {
                    return Individually;
                }
            }
            throw new IllegalArgumentException("Unknown trim path type " + id);
        }
    }
}

