/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Color;
import android.support.annotation.IntRange;
import android.util.Log;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.AnimatableValueParser;
import com.airbnb.lottie.BaseAnimatableValue;
import com.airbnb.lottie.GradientColor;
import com.airbnb.lottie.GradientColorKeyframeAnimation;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.MiscUtils;
import com.airbnb.lottie.StaticKeyframeAnimation;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class AnimatableGradientColorValue
extends BaseAnimatableValue<GradientColor, GradientColor> {
    private AnimatableGradientColorValue(List<Keyframe<GradientColor>> keyframes, GradientColor initialValue) {
        super(keyframes, initialValue);
    }

    public KeyframeAnimation<GradientColor> createAnimation() {
        if (!this.hasAnimation()) {
            return new StaticKeyframeAnimation<Object>(this.initialValue);
        }
        return new GradientColorKeyframeAnimation(this.keyframes);
    }

    private static class ValueFactory
    implements AnimatableValue.Factory<GradientColor> {
        private final int colorPoints;

        private ValueFactory(int colorPoints) {
            this.colorPoints = colorPoints;
        }

        @Override
        public GradientColor valueFromObject(Object object, float scale) {
            JSONArray array = (JSONArray)object;
            float[] positions = new float[this.colorPoints];
            int[] colors = new int[this.colorPoints];
            GradientColor gradientColor = new GradientColor(positions, colors);
            int r = 0;
            int g = 0;
            if (array.length() != this.colorPoints * 4) {
                Log.w((String)"LOTTIE", (String)("Unexpected gradient length: " + array.length() + ". Expected " + this.colorPoints * 4 + ". This may affect the appearance of the gradient. " + "Make sure to save your After Effects file before exporting an animation with " + "gradients."));
            }
            block6: for (int i = 0; i < this.colorPoints * 4; ++i) {
                int colorIndex = i / 4;
                double value = array.optDouble(i);
                switch (i % 4) {
                    case 0: {
                        positions[colorIndex] = (float)value;
                        continue block6;
                    }
                    case 1: {
                        r = (int)(value * 255.0);
                        continue block6;
                    }
                    case 2: {
                        g = (int)(value * 255.0);
                        continue block6;
                    }
                    case 3: {
                        int b = (int)(value * 255.0);
                        colors[colorIndex] = Color.argb((int)255, (int)r, (int)g, (int)b);
                    }
                }
            }
            this.addOpacityStopsToGradientIfNeeded(gradientColor, array);
            return gradientColor;
        }

        private void addOpacityStopsToGradientIfNeeded(GradientColor gradientColor, JSONArray array) {
            int i;
            int startIndex = this.colorPoints * 4;
            if (array.length() <= startIndex) {
                return;
            }
            int opacityStops = (array.length() - startIndex) / 2;
            double[] positions = new double[opacityStops];
            double[] opacities = new double[opacityStops];
            int j = 0;
            for (i = startIndex; i < array.length(); ++i) {
                if (i % 2 == 0) {
                    positions[j] = array.optDouble(i);
                    continue;
                }
                opacities[j] = array.optDouble(i);
                ++j;
            }
            for (i = 0; i < gradientColor.getSize(); ++i) {
                int color = gradientColor.getColors()[i];
                gradientColor.getColors()[i] = color = Color.argb((int)this.getOpacityAtPosition(gradientColor.getPositions()[i], positions, opacities), (int)Color.red((int)color), (int)Color.green((int)color), (int)Color.blue((int)color));
            }
        }

        @IntRange(from=0L, to=255L)
        private int getOpacityAtPosition(double position, double[] positions, double[] opacities) {
            for (int i = 1; i < positions.length; ++i) {
                double lastPosition = positions[i - 1];
                double thisPosition = positions[i];
                if (!(positions[i] >= position)) continue;
                double progress = (position - lastPosition) / (thisPosition - lastPosition);
                return (int)(255.0 * MiscUtils.lerp(opacities[i - 1], opacities[i], progress));
            }
            return (int)(255.0 * opacities[opacities.length - 1]);
        }
    }

    static final class Factory {
        private Factory() {
        }

        static AnimatableGradientColorValue newInstance(JSONObject json, LottieComposition composition) {
            int points = json.optInt("p", json.optJSONArray("k").length() / 4);
            AnimatableValueParser.Result<GradientColor> result = AnimatableValueParser.newInstance(json, 1.0f, composition, new ValueFactory(points)).parseJson();
            GradientColor initialValue = (GradientColor)result.initialValue;
            return new AnimatableGradientColorValue(result.keyframes, initialValue);
        }
    }
}

