/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.Log;
import android.view.View;
import com.airbnb.lottie.FontAssetDelegate;
import com.airbnb.lottie.MutablePair;
import java.util.HashMap;
import java.util.Map;

class FontAssetManager {
    private final MutablePair<String> tempPair = new MutablePair();
    private final Map<MutablePair<String>, Typeface> fontMap = new HashMap<MutablePair<String>, Typeface>();
    private final Map<String, Typeface> fontFamilies = new HashMap<String, Typeface>();
    private final AssetManager assetManager;
    @Nullable
    private FontAssetDelegate delegate;
    private String defaultFontFileExtension = ".ttf";

    FontAssetManager(Drawable.Callback callback, @Nullable FontAssetDelegate delegate) {
        this.delegate = delegate;
        if (!(callback instanceof View)) {
            Log.w((String)"LOTTIE", (String)"LottieDrawable must be inside of a view for images to work.");
            this.assetManager = null;
            return;
        }
        this.assetManager = ((View)callback).getContext().getAssets();
    }

    void setDelegate(@Nullable FontAssetDelegate assetDelegate) {
        this.delegate = assetDelegate;
    }

    public void setDefaultFontFileExtension(String defaultFontFileExtension) {
        this.defaultFontFileExtension = defaultFontFileExtension;
    }

    Typeface getTypeface(String fontFamily, String style) {
        this.tempPair.set(fontFamily, style);
        Typeface typeface = this.fontMap.get(this.tempPair);
        if (typeface != null) {
            return typeface;
        }
        Typeface typefaceWithDefaultStyle = this.getFontFamily(fontFamily);
        typeface = this.typefaceForStyle(typefaceWithDefaultStyle, style);
        this.fontMap.put(this.tempPair, typeface);
        return typeface;
    }

    private Typeface getFontFamily(String fontFamily) {
        String path;
        Typeface defaultTypeface = this.fontFamilies.get(fontFamily);
        if (defaultTypeface != null) {
            return defaultTypeface;
        }
        Typeface typeface = null;
        if (this.delegate != null) {
            typeface = this.delegate.fetchFont(fontFamily);
        }
        if (this.delegate != null && typeface == null && (path = this.delegate.getFontPath(fontFamily)) != null) {
            typeface = Typeface.createFromAsset((AssetManager)this.assetManager, (String)path);
        }
        if (typeface == null) {
            path = "fonts/" + fontFamily + this.defaultFontFileExtension;
            typeface = Typeface.createFromAsset((AssetManager)this.assetManager, (String)path);
        }
        this.fontFamilies.put(fontFamily, typeface);
        return typeface;
    }

    private Typeface typefaceForStyle(Typeface typeface, String style) {
        int styleInt = 0;
        boolean containsItalic = style.contains("Italic");
        boolean containsBold = style.contains("Bold");
        if (containsItalic && containsBold) {
            styleInt = 3;
        } else if (containsItalic) {
            styleInt = 2;
        } else if (containsBold) {
            styleInt = 1;
        }
        if (typeface.getStyle() == styleInt) {
            return typeface;
        }
        return Typeface.create((Typeface)typeface, (int)styleInt);
    }
}

