/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.ShapeGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

class FontCharacter {
    private final List<ShapeGroup> shapes;
    private final char character;
    private final int size;
    private final double width;
    private final String style;
    private final String fontFamily;

    static int hashFor(char character, String fontFamily, String style) {
        int result = 0;
        result = 31 * result + character;
        result = 31 * result + fontFamily.hashCode();
        result = 31 * result + style.hashCode();
        return result;
    }

    FontCharacter(List<ShapeGroup> shapes, char character, int size, double width, String style, String fontFamily) {
        this.shapes = shapes;
        this.character = character;
        this.size = size;
        this.width = width;
        this.style = style;
        this.fontFamily = fontFamily;
    }

    List<ShapeGroup> getShapes() {
        return this.shapes;
    }

    int getSize() {
        return this.size;
    }

    double getWidth() {
        return this.width;
    }

    String getStyle() {
        return this.style;
    }

    public int hashCode() {
        return FontCharacter.hashFor(this.character, this.fontFamily, this.style);
    }

    static class Factory {
        Factory() {
        }

        static FontCharacter newInstance(JSONObject json, LottieComposition composition) {
            char character = json.optString("ch").charAt(0);
            int size = json.optInt("size");
            double width = json.optDouble("w");
            String style = json.optString("style");
            String fontFamily = json.optString("fFamily");
            JSONArray shapesJson = json.optJSONObject("data").optJSONArray("shapes");
            List<ShapeGroup> shapes = Collections.emptyList();
            if (shapesJson != null) {
                shapes = new ArrayList(shapesJson.length());
                for (int i = 0; i < shapesJson.length(); ++i) {
                    shapes.add((ShapeGroup)ShapeGroup.shapeItemWithJson(shapesJson.optJSONObject(i), composition));
                }
            }
            return new FontCharacter(shapes, character, size, width, style, fontFamily);
        }
    }
}

