/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Path;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.view.animation.Interpolator;
import com.airbnb.lottie.AnimatableValue;
import com.airbnb.lottie.JsonUtils;
import com.airbnb.lottie.Keyframe;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.Utils;
import org.json.JSONArray;
import org.json.JSONObject;

class PathKeyframe
extends Keyframe<PointF> {
    @Nullable
    private Path path;

    private PathKeyframe(LottieComposition composition, @Nullable PointF startValue, @Nullable PointF endValue, @Nullable Interpolator interpolator, float startFrame, @Nullable Float endFrame) {
        super(composition, startValue, endValue, interpolator, startFrame, endFrame);
    }

    @Nullable
    Path getPath() {
        return this.path;
    }

    static class Factory {
        private Factory() {
        }

        static PathKeyframe newInstance(JSONObject json, LottieComposition composition, AnimatableValue.Factory<PointF> valueFactory) {
            boolean equals;
            Keyframe<PointF> keyframe = Keyframe.Factory.newInstance(json, composition, composition.getDpScale(), valueFactory);
            PointF cp1 = null;
            PointF cp2 = null;
            JSONArray tiJson = json.optJSONArray("ti");
            JSONArray toJson = json.optJSONArray("to");
            if (tiJson != null && toJson != null) {
                cp1 = JsonUtils.pointFromJsonArray(toJson, composition.getDpScale());
                cp2 = JsonUtils.pointFromJsonArray(tiJson, composition.getDpScale());
            }
            PathKeyframe pathKeyframe = new PathKeyframe(composition, (PointF)keyframe.startValue, (PointF)keyframe.endValue, keyframe.interpolator, keyframe.startFrame, keyframe.endFrame);
            boolean bl = equals = keyframe.endValue != null && keyframe.startValue != null && ((PointF)keyframe.startValue).equals(((PointF)keyframe.endValue).x, ((PointF)keyframe.endValue).y);
            if (pathKeyframe.endValue != null && !equals) {
                pathKeyframe.path = Utils.createPath((PointF)keyframe.startValue, (PointF)keyframe.endValue, cp1, cp2);
            }
            return pathKeyframe;
        }
    }
}

