/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.support.annotation.Nullable;
import com.airbnb.lottie.AnimatableFloatValue;
import com.airbnb.lottie.AnimatableTransform;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.ContentModel;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.RepeaterContent;
import org.json.JSONObject;

class Repeater
implements ContentModel {
    private final String name;
    private final AnimatableFloatValue copies;
    private final AnimatableFloatValue offset;
    private final AnimatableTransform transform;

    Repeater(String name, AnimatableFloatValue copies, AnimatableFloatValue offset, AnimatableTransform transform) {
        this.name = name;
        this.copies = copies;
        this.offset = offset;
        this.transform = transform;
    }

    String getName() {
        return this.name;
    }

    AnimatableFloatValue getCopies() {
        return this.copies;
    }

    AnimatableFloatValue getOffset() {
        return this.offset;
    }

    AnimatableTransform getTransform() {
        return this.transform;
    }

    @Override
    @Nullable
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new RepeaterContent(drawable, layer, this);
    }

    static final class Factory {
        private Factory() {
        }

        static Repeater newInstance(JSONObject json, LottieComposition composition) {
            String name = json.optString("nm");
            AnimatableFloatValue copies = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("c"), composition, false);
            AnimatableFloatValue offset = AnimatableFloatValue.Factory.newInstance(json.optJSONObject("o"), composition, false);
            AnimatableTransform transform = AnimatableTransform.Factory.newInstance(json.optJSONObject("tr"), composition);
            return new Repeater(name, copies, offset, transform);
        }
    }
}

