/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseKeyframeAnimation;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Content;
import com.airbnb.lottie.ContentGroup;
import com.airbnb.lottie.DrawingContent;
import com.airbnb.lottie.GreedyContent;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.MiscUtils;
import com.airbnb.lottie.PathContent;
import com.airbnb.lottie.Repeater;
import com.airbnb.lottie.TransformKeyframeAnimation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

public class RepeaterContent
implements DrawingContent,
PathContent,
GreedyContent,
BaseKeyframeAnimation.AnimationListener {
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final LottieDrawable lottieDrawable;
    private final BaseLayer layer;
    private final String name;
    private final KeyframeAnimation<Float> copies;
    private final KeyframeAnimation<Float> offset;
    private final TransformKeyframeAnimation transform;
    private ContentGroup contentGroup;

    RepeaterContent(LottieDrawable lottieDrawable, BaseLayer layer, Repeater repeater) {
        this.lottieDrawable = lottieDrawable;
        this.layer = layer;
        this.name = repeater.getName();
        this.copies = repeater.getCopies().createAnimation();
        layer.addAnimation(this.copies);
        this.copies.addUpdateListener(this);
        this.offset = repeater.getOffset().createAnimation();
        layer.addAnimation(this.offset);
        this.offset.addUpdateListener(this);
        this.transform = repeater.getTransform().createAnimation();
        this.transform.addAnimationsToLayer(layer);
        this.transform.addListener(this);
    }

    @Override
    public void absorbContent(ListIterator<Content> contentsIter) {
        if (this.contentGroup != null) {
            return;
        }
        while (contentsIter.hasPrevious() && contentsIter.previous() != this) {
        }
        ArrayList<Content> contents = new ArrayList<Content>();
        while (contentsIter.hasPrevious()) {
            contents.add(contentsIter.previous());
            contentsIter.remove();
        }
        Collections.reverse(contents);
        this.contentGroup = new ContentGroup(this.lottieDrawable, this.layer, "Repeater", contents, null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setContents(List<Content> contentsBefore, List<Content> contentsAfter) {
        this.contentGroup.setContents(contentsBefore, contentsAfter);
    }

    @Override
    public Path getPath() {
        Path contentPath = this.contentGroup.getPath();
        this.path.reset();
        float copies = ((Float)this.copies.getValue()).floatValue();
        float offset = ((Float)this.offset.getValue()).floatValue();
        for (int i = (int)copies - 1; i >= 0; --i) {
            this.matrix.set(this.transform.getMatrixForRepeater((float)i + offset));
            this.path.addPath(contentPath, this.matrix);
        }
        return this.path;
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int alpha) {
        float copies = ((Float)this.copies.getValue()).floatValue();
        float offset = ((Float)this.offset.getValue()).floatValue();
        float startOpacity = this.transform.getStartOpacity().getValue().floatValue() / 100.0f;
        float endOpacity = this.transform.getEndOpacity().getValue().floatValue() / 100.0f;
        for (int i = (int)copies - 1; i >= 0; --i) {
            this.matrix.set(parentMatrix);
            this.matrix.preConcat(this.transform.getMatrixForRepeater((float)i + offset));
            float newAlpha = (float)alpha * MiscUtils.lerp(startOpacity, endOpacity, (float)i / copies);
            this.contentGroup.draw(canvas, this.matrix, (int)newAlpha);
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        this.contentGroup.getBounds(outBounds, parentMatrix);
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        this.contentGroup.addColorFilter(layerName, contentName, colorFilter);
    }

    @Override
    public void onValueChanged() {
        this.lottieDrawable.invalidateSelf();
    }
}

