/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.Layer;
import com.airbnb.lottie.LottieDrawable;

class SolidLayer
extends BaseLayer {
    private final RectF rect = new RectF();
    private final Paint paint = new Paint();
    private final Layer layerModel;

    SolidLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
        this.layerModel = layerModel;
        this.paint.setAlpha(0);
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(layerModel.getSolidColor());
    }

    @Override
    public void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        int backgroundAlpha = Color.alpha((int)this.layerModel.getSolidColor());
        if (backgroundAlpha == 0) {
            return;
        }
        int alpha = (int)((float)backgroundAlpha / 255.0f * (float)this.transform.getOpacity().getValue().intValue() / 100.0f * 255.0f);
        this.paint.setAlpha(alpha);
        if (alpha > 0) {
            this.updateRect(parentMatrix);
            canvas.drawRect(this.rect, this.paint);
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix) {
        super.getBounds(outBounds, parentMatrix);
        this.updateRect(this.boundsMatrix);
        outBounds.set(this.rect);
    }

    private void updateRect(Matrix matrix) {
        this.rect.set(0.0f, 0.0f, (float)this.layerModel.getSolidWidth(), (float)this.layerModel.getSolidHeight());
        matrix.mapRect(this.rect);
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }
}

