/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.support.annotation.Nullable;
import com.airbnb.lottie.BaseLayer;
import com.airbnb.lottie.BaseStrokeContent;
import com.airbnb.lottie.KeyframeAnimation;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.ShapeStroke;

class StrokeContent
extends BaseStrokeContent {
    private final String name;
    private final KeyframeAnimation<Integer> colorAnimation;

    StrokeContent(LottieDrawable lottieDrawable, BaseLayer layer, ShapeStroke stroke) {
        super(lottieDrawable, layer, stroke.getCapType().toPaintCap(), stroke.getJoinType().toPaintJoin(), stroke.getOpacity(), stroke.getWidth(), stroke.getLineDashPattern(), stroke.getDashOffset());
        this.name = stroke.getName();
        this.colorAnimation = stroke.getColor().createAnimation();
        this.colorAnimation.addUpdateListener(this);
        layer.addAnimation(this.colorAnimation);
    }

    @Override
    public void addColorFilter(@Nullable String layerName, @Nullable String contentName, @Nullable ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    @Override
    public void draw(Canvas canvas, Matrix parentMatrix, int parentAlpha) {
        this.paint.setColor(((Integer)this.colorAnimation.getValue()).intValue());
        super.draw(canvas, parentMatrix, parentAlpha);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

