/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.PointF;
import android.support.annotation.Nullable;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.MiscUtils;
import com.airbnb.lottie.TrimPathContent;
import java.io.Closeable;

final class Utils {
    private static final PathMeasure pathMeasure = new PathMeasure();
    private static final Path tempPath = new Path();
    private static final Path tempPath2 = new Path();
    private static DisplayMetrics displayMetrics;
    private static final float[] points;
    private static final float SQRT_2;

    private Utils() {
    }

    static Path createPath(PointF startPoint, PointF endPoint, PointF cp1, PointF cp2) {
        Path path = new Path();
        path.moveTo(startPoint.x, startPoint.y);
        if (cp1 != null && cp2 != null && (cp1.length() != 0.0f || cp2.length() != 0.0f)) {
            path.cubicTo(startPoint.x + cp1.x, startPoint.y + cp1.y, endPoint.x + cp2.x, endPoint.y + cp2.y, endPoint.x, endPoint.y);
        } else {
            path.lineTo(endPoint.x, endPoint.y);
        }
        return path;
    }

    static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static int getScreenWidth(Context context) {
        if (displayMetrics == null) {
            displayMetrics = new DisplayMetrics();
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(displayMetrics);
        return Utils.displayMetrics.widthPixels;
    }

    static int getScreenHeight(Context context) {
        if (displayMetrics == null) {
            displayMetrics = new DisplayMetrics();
        }
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(displayMetrics);
        return Utils.displayMetrics.heightPixels;
    }

    static float getScale(Matrix matrix) {
        Utils.points[0] = 0.0f;
        Utils.points[1] = 0.0f;
        Utils.points[2] = SQRT_2;
        Utils.points[3] = SQRT_2;
        matrix.mapPoints(points);
        float dx = points[2] - points[0];
        float dy = points[3] - points[1];
        return (float)Math.hypot(dx, dy) / 2.0f;
    }

    static void applyTrimPathIfNeeded(Path path, @Nullable TrimPathContent trimPath) {
        if (trimPath == null) {
            return;
        }
        Utils.applyTrimPathIfNeeded(path, trimPath.getStart().getValue().floatValue() / 100.0f, trimPath.getEnd().getValue().floatValue() / 100.0f, trimPath.getOffset().getValue().floatValue() / 360.0f);
    }

    static void applyTrimPathIfNeeded(Path path, float startValue, float endValue, float offsetValue) {
        L.beginSection("applyTrimPathIfNeeded");
        pathMeasure.setPath(path, false);
        float length = pathMeasure.getLength();
        if (startValue == 1.0f && endValue == 0.0f) {
            L.endSection("applyTrimPathIfNeeded");
            return;
        }
        if (length < 1.0f || (double)Math.abs(endValue - startValue - 1.0f) < 0.01) {
            L.endSection("applyTrimPathIfNeeded");
            return;
        }
        float start = length * startValue;
        float end = length * endValue;
        float newStart = Math.min(start, end);
        float newEnd = Math.max(start, end);
        float offset = offsetValue * length;
        newStart += offset;
        newEnd += offset;
        if (newStart >= length && newEnd >= length) {
            newStart = MiscUtils.floorMod(newStart, length);
            newEnd = MiscUtils.floorMod(newEnd, length);
        }
        if (newStart < 0.0f) {
            newStart = MiscUtils.floorMod(newStart, length);
        }
        if (newEnd < 0.0f) {
            newEnd = MiscUtils.floorMod(newEnd, length);
        }
        if (newStart == newEnd) {
            path.reset();
            L.endSection("applyTrimPathIfNeeded");
            return;
        }
        if (newStart >= newEnd) {
            newStart -= length;
        }
        tempPath.reset();
        pathMeasure.getSegment(newStart, newEnd, tempPath, true);
        if (newEnd > length) {
            tempPath2.reset();
            pathMeasure.getSegment(0.0f, newEnd % length, tempPath2, true);
            tempPath.addPath(tempPath2);
        } else if (newStart < 0.0f) {
            tempPath2.reset();
            pathMeasure.getSegment(length + newStart, length, tempPath2, true);
            tempPath.addPath(tempPath2);
        }
        path.set(tempPath);
        L.endSection("applyTrimPathIfNeeded");
    }

    static boolean isAtLeastVersion(LottieComposition composition, int major, int minor, int patch) {
        if (composition.getMajorVersion() < major) {
            return false;
        }
        if (composition.getMajorVersion() > major) {
            return true;
        }
        if (composition.getMinorVersion() < minor) {
            return false;
        }
        if (composition.getMinorVersion() > minor) {
            return true;
        }
        return composition.getPatchVersion() >= patch;
    }

    static int hashFor(float a, float b, float c, float d) {
        int result = 17;
        if (a != 0.0f) {
            result = (int)((float)(31 * result) * a);
        }
        if (b != 0.0f) {
            result = (int)((float)(31 * result) * b);
        }
        if (c != 0.0f) {
            result = (int)((float)(31 * result) * c);
        }
        if (d != 0.0f) {
            result = (int)((float)(31 * result) * d);
        }
        return result;
    }

    static {
        points = new float[4];
        SQRT_2 = (float)Math.sqrt(2.0);
    }
}

