/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model;

import android.support.annotation.ColorInt;
import android.util.JsonReader;
import com.airbnb.lottie.utils.JsonUtils;
import java.io.IOException;

public class DocumentData {
    public String text;
    public String fontName;
    public double size;
    int justification;
    public int tracking;
    double lineHeight;
    public double baselineShift;
    @ColorInt
    public int color;
    @ColorInt
    public int strokeColor;
    public int strokeWidth;
    public boolean strokeOverFill;

    DocumentData(String text, String fontName, double size, int justification, int tracking, double lineHeight, double baselineShift, @ColorInt int color, @ColorInt int strokeColor, int strokeWidth, boolean strokeOverFill) {
        this.text = text;
        this.fontName = fontName;
        this.size = size;
        this.justification = justification;
        this.tracking = tracking;
        this.lineHeight = lineHeight;
        this.baselineShift = baselineShift;
        this.color = color;
        this.strokeColor = strokeColor;
        this.strokeWidth = strokeWidth;
        this.strokeOverFill = strokeOverFill;
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.fontName.hashCode();
        result = (int)((double)(31 * result) + this.size);
        result = 31 * result + this.justification;
        result = 31 * result + this.tracking;
        long temp = Double.doubleToLongBits(this.lineHeight);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.color;
        return result;
    }

    public static final class Factory {
        private Factory() {
        }

        public static DocumentData newInstance(JsonReader reader) throws IOException {
            String text = null;
            String fontName = null;
            double size = 0.0;
            int justification = 0;
            int tracking = 0;
            double lineHeight = 0.0;
            double baselineShift = 0.0;
            int fillColor = 0;
            int strokeColor = 0;
            int strokeWidth = 0;
            boolean strokeOverFill = true;
            reader.beginObject();
            block26: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "t": {
                        text = reader.nextString();
                        continue block26;
                    }
                    case "f": {
                        fontName = reader.nextString();
                        continue block26;
                    }
                    case "s": {
                        size = reader.nextDouble();
                        continue block26;
                    }
                    case "j": {
                        justification = reader.nextInt();
                        continue block26;
                    }
                    case "tr": {
                        tracking = reader.nextInt();
                        continue block26;
                    }
                    case "lh": {
                        lineHeight = reader.nextDouble();
                        continue block26;
                    }
                    case "ls": {
                        baselineShift = reader.nextDouble();
                        continue block26;
                    }
                    case "fc": {
                        fillColor = JsonUtils.jsonToColor(reader);
                        continue block26;
                    }
                    case "sc": {
                        strokeColor = JsonUtils.jsonToColor(reader);
                        continue block26;
                    }
                    case "sw": {
                        strokeWidth = reader.nextInt();
                        continue block26;
                    }
                    case "of": {
                        strokeOverFill = reader.nextBoolean();
                        continue block26;
                    }
                }
                reader.skipValue();
            }
            reader.endObject();
            return new DocumentData(text, fontName, size, justification, tracking, lineHeight, baselineShift, fillColor, strokeColor, strokeWidth, strokeOverFill);
        }
    }
}

