/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.PointF;
import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.EllipseContent;
import com.airbnb.lottie.model.animatable.AnimatablePathValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;

public class CircleShape
implements ContentModel {
    private final String name;
    private final AnimatableValue<PointF, PointF> position;
    private final AnimatablePointValue size;
    private final boolean isReversed;

    private CircleShape(String name, AnimatableValue<PointF, PointF> position, AnimatablePointValue size, boolean isReversed) {
        this.name = name;
        this.position = position;
        this.size = size;
        this.isReversed = isReversed;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new EllipseContent(drawable, layer, this);
    }

    public String getName() {
        return this.name;
    }

    public AnimatableValue<PointF, PointF> getPosition() {
        return this.position;
    }

    public AnimatablePointValue getSize() {
        return this.size;
    }

    public boolean isReversed() {
        return this.isReversed;
    }

    static class Factory {
        private Factory() {
        }

        static CircleShape newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String name = null;
            AnimatableValue<PointF, PointF> position = null;
            AnimatablePointValue size = null;
            boolean reversed = false;
            block12: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block12;
                    }
                    case "p": {
                        position = AnimatablePathValue.createAnimatablePathOrSplitDimensionPath(reader, composition);
                        continue block12;
                    }
                    case "s": {
                        size = AnimatablePointValue.Factory.newInstance(reader, composition);
                        continue block12;
                    }
                    case "d": {
                        reversed = reader.nextInt() == 3;
                        continue block12;
                    }
                }
                reader.skipValue();
            }
            return new CircleShape(name, position, size, reversed);
        }
    }
}

