/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatableShapeValue;
import java.io.IOException;

public class Mask {
    private final MaskMode maskMode;
    private final AnimatableShapeValue maskPath;
    private final AnimatableIntegerValue opacity;

    private Mask(MaskMode maskMode, AnimatableShapeValue maskPath, AnimatableIntegerValue opacity) {
        this.maskMode = maskMode;
        this.maskPath = maskPath;
        this.opacity = opacity;
    }

    public MaskMode getMaskMode() {
        return this.maskMode;
    }

    public AnimatableShapeValue getMaskPath() {
        return this.maskPath;
    }

    public AnimatableIntegerValue getOpacity() {
        return this.opacity;
    }

    public static class Factory {
        private Factory() {
        }

        public static Mask newMask(JsonReader reader, LottieComposition composition) throws IOException {
            MaskMode maskMode = null;
            AnimatableShapeValue maskPath = null;
            AnimatableIntegerValue opacity = null;
            reader.beginObject();
            while (reader.hasNext()) {
                String mode;
                block5 : switch (mode = reader.nextName()) {
                    case "mode": {
                        switch (reader.nextString()) {
                            case "a": {
                                maskMode = MaskMode.MaskModeAdd;
                                break block5;
                            }
                            case "s": {
                                maskMode = MaskMode.MaskModeSubtract;
                                break block5;
                            }
                            case "i": {
                                maskMode = MaskMode.MaskModeIntersect;
                                break block5;
                            }
                        }
                        Log.w((String)"LOTTIE", (String)("Unknown mask mode " + mode + ". Defaulting to Add."));
                        maskMode = MaskMode.MaskModeAdd;
                        break;
                    }
                    case "pt": {
                        maskPath = AnimatableShapeValue.Factory.newInstance(reader, composition);
                        break;
                    }
                    case "o": {
                        opacity = AnimatableIntegerValue.Factory.newInstance(reader, composition);
                        break;
                    }
                    default: {
                        reader.skipValue();
                    }
                }
            }
            reader.endObject();
            return new Mask(maskMode, maskPath, opacity);
        }
    }

    public static enum MaskMode {
        MaskModeAdd,
        MaskModeSubtract,
        MaskModeIntersect;

    }
}

