/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.graphics.PointF;
import android.support.annotation.FloatRange;
import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.model.CubicCurveData;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.utils.JsonUtils;
import com.airbnb.lottie.utils.MiscUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ShapeData {
    private final List<CubicCurveData> curves = new ArrayList<CubicCurveData>();
    private PointF initialPoint;
    private boolean closed;

    private ShapeData(PointF initialPoint, boolean closed, List<CubicCurveData> curves) {
        this.initialPoint = initialPoint;
        this.closed = closed;
        this.curves.addAll(curves);
    }

    public ShapeData() {
    }

    private void setInitialPoint(float x, float y) {
        if (this.initialPoint == null) {
            this.initialPoint = new PointF();
        }
        this.initialPoint.set(x, y);
    }

    public PointF getInitialPoint() {
        return this.initialPoint;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public List<CubicCurveData> getCurves() {
        return this.curves;
    }

    public void interpolateBetween(ShapeData shapeData1, ShapeData shapeData2, @FloatRange(from=0.0, to=1.0) float percentage) {
        if (this.initialPoint == null) {
            this.initialPoint = new PointF();
        }
        boolean bl = this.closed = shapeData1.isClosed() || shapeData2.isClosed();
        if (!this.curves.isEmpty() && this.curves.size() != shapeData1.getCurves().size() && this.curves.size() != shapeData2.getCurves().size()) {
            throw new IllegalStateException("Curves must have the same number of control points. This: " + this.getCurves().size() + "\tShape 1: " + shapeData1.getCurves().size() + "\tShape 2: " + shapeData2.getCurves().size());
        }
        if (this.curves.isEmpty()) {
            for (int i = shapeData1.getCurves().size() - 1; i >= 0; --i) {
                this.curves.add(new CubicCurveData());
            }
        }
        PointF initialPoint1 = shapeData1.getInitialPoint();
        PointF initialPoint2 = shapeData2.getInitialPoint();
        this.setInitialPoint(MiscUtils.lerp(initialPoint1.x, initialPoint2.x, percentage), MiscUtils.lerp(initialPoint1.y, initialPoint2.y, percentage));
        for (int i = this.curves.size() - 1; i >= 0; --i) {
            CubicCurveData curve1 = shapeData1.getCurves().get(i);
            CubicCurveData curve2 = shapeData2.getCurves().get(i);
            PointF cp11 = curve1.getControlPoint1();
            PointF cp21 = curve1.getControlPoint2();
            PointF vertex1 = curve1.getVertex();
            PointF cp12 = curve2.getControlPoint1();
            PointF cp22 = curve2.getControlPoint2();
            PointF vertex2 = curve2.getVertex();
            this.curves.get(i).setControlPoint1(MiscUtils.lerp(cp11.x, cp12.x, percentage), MiscUtils.lerp(cp11.y, cp12.y, percentage));
            this.curves.get(i).setControlPoint2(MiscUtils.lerp(cp21.x, cp22.x, percentage), MiscUtils.lerp(cp21.y, cp22.y, percentage));
            this.curves.get(i).setVertex(MiscUtils.lerp(vertex1.x, vertex2.x, percentage), MiscUtils.lerp(vertex1.y, vertex2.y, percentage));
        }
    }

    public String toString() {
        return "ShapeData{numCurves=" + this.curves.size() + "closed=" + this.closed + '}';
    }

    public static class Factory
    implements AnimatableValue.Factory<ShapeData> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public ShapeData valueFromObject(JsonReader reader, float scale) throws IOException {
            PointF vertex;
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                reader.beginArray();
            }
            boolean closed = false;
            List<PointF> pointsArray = null;
            List<PointF> inTangents = null;
            List<PointF> outTangents = null;
            reader.beginObject();
            while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "c": {
                        closed = reader.nextBoolean();
                        break;
                    }
                    case "v": {
                        pointsArray = JsonUtils.jsonToPoints(reader, scale);
                        break;
                    }
                    case "i": {
                        inTangents = JsonUtils.jsonToPoints(reader, scale);
                        break;
                    }
                    case "o": {
                        outTangents = JsonUtils.jsonToPoints(reader, scale);
                    }
                }
            }
            reader.endObject();
            if (reader.peek() == JsonToken.END_ARRAY) {
                reader.endArray();
            }
            if (pointsArray == null || inTangents == null || outTangents == null) {
                throw new IllegalArgumentException("Shape data was missing information.");
            }
            if (pointsArray.isEmpty()) {
                return new ShapeData(new PointF(), false, Collections.emptyList());
            }
            int length = pointsArray.size();
            PointF initialPoint = vertex = pointsArray.get(0);
            ArrayList<CubicCurveData> curves = new ArrayList<CubicCurveData>(length);
            for (int i = 1; i < length; ++i) {
                vertex = pointsArray.get(i);
                PointF previousVertex = pointsArray.get(i - 1);
                PointF cp1 = outTangents.get(i - 1);
                PointF cp2 = inTangents.get(i);
                PointF shapeCp1 = MiscUtils.addPoints(previousVertex, cp1);
                PointF shapeCp2 = MiscUtils.addPoints(vertex, cp2);
                curves.add(new CubicCurveData(shapeCp1, shapeCp2, vertex));
            }
            if (closed) {
                vertex = pointsArray.get(0);
                PointF previousVertex = pointsArray.get(length - 1);
                PointF cp1 = outTangents.get(length - 1);
                PointF cp2 = inTangents.get(0);
                PointF shapeCp1 = MiscUtils.addPoints(previousVertex, cp1);
                PointF shapeCp2 = MiscUtils.addPoints(vertex, cp2);
                curves.add(new CubicCurveData(shapeCp1, shapeCp2, vertex));
            }
            return new ShapeData(initialPoint, closed, curves);
        }
    }
}

