/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.content;

import android.support.annotation.Nullable;
import android.util.JsonReader;
import android.util.Log;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.animation.content.Content;
import com.airbnb.lottie.animation.content.ContentGroup;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.CircleShape;
import com.airbnb.lottie.model.content.ContentModel;
import com.airbnb.lottie.model.content.GradientFill;
import com.airbnb.lottie.model.content.GradientStroke;
import com.airbnb.lottie.model.content.MergePaths;
import com.airbnb.lottie.model.content.PolystarShape;
import com.airbnb.lottie.model.content.RectangleShape;
import com.airbnb.lottie.model.content.Repeater;
import com.airbnb.lottie.model.content.ShapeFill;
import com.airbnb.lottie.model.content.ShapePath;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.model.content.ShapeTrimPath;
import com.airbnb.lottie.model.layer.BaseLayer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ShapeGroup
implements ContentModel {
    private final String name;
    private final List<ContentModel> items;

    @Nullable
    public static ContentModel shapeItemWithJson(JsonReader reader, LottieComposition composition) throws IOException {
        String type = null;
        reader.beginObject();
        while (reader.hasNext()) {
            if (reader.nextName().equals("ty")) {
                type = reader.nextString();
                break;
            }
            reader.skipValue();
        }
        ContentModel model = null;
        switch (type) {
            case "gr": {
                model = Factory.newInstance(reader, composition);
                break;
            }
            case "st": {
                model = ShapeStroke.Factory.newInstance(reader, composition);
                break;
            }
            case "gs": {
                model = GradientStroke.Factory.newInstance(reader, composition);
                break;
            }
            case "fl": {
                model = ShapeFill.Factory.newInstance(reader, composition);
                break;
            }
            case "gf": {
                model = GradientFill.Factory.newInstance(reader, composition);
                break;
            }
            case "tr": {
                model = AnimatableTransform.Factory.newInstance(reader, composition);
                break;
            }
            case "sh": {
                model = ShapePath.Factory.newInstance(reader, composition);
                break;
            }
            case "el": {
                model = CircleShape.Factory.newInstance(reader, composition);
                break;
            }
            case "rc": {
                model = RectangleShape.Factory.newInstance(reader, composition);
                break;
            }
            case "tm": {
                model = ShapeTrimPath.Factory.newInstance(reader, composition);
                break;
            }
            case "sr": {
                model = PolystarShape.Factory.newInstance(reader, composition);
                break;
            }
            case "mm": {
                model = MergePaths.Factory.newInstance(reader);
                break;
            }
            case "rp": {
                model = Repeater.Factory.newInstance(reader, composition);
                break;
            }
            default: {
                Log.w((String)"LOTTIE", (String)("Unknown shape type " + type));
            }
        }
        while (reader.hasNext()) {
            reader.skipValue();
        }
        reader.endObject();
        return model;
    }

    public ShapeGroup(String name, List<ContentModel> items) {
        this.name = name;
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    public List<ContentModel> getItems() {
        return this.items;
    }

    @Override
    public Content toContent(LottieDrawable drawable, BaseLayer layer) {
        return new ContentGroup(drawable, layer, this);
    }

    public String toString() {
        return "ShapeGroup{name='" + this.name + "' Shapes: " + Arrays.toString(this.items.toArray()) + '}';
    }

    static class Factory {
        private Factory() {
        }

        private static ShapeGroup newInstance(JsonReader reader, LottieComposition composition) throws IOException {
            String name = null;
            ArrayList<ContentModel> items = new ArrayList<ContentModel>();
            block8: while (reader.hasNext()) {
                switch (reader.nextName()) {
                    case "nm": {
                        name = reader.nextString();
                        continue block8;
                    }
                    case "it": {
                        reader.beginArray();
                        while (reader.hasNext()) {
                            ContentModel newItem = ShapeGroup.shapeItemWithJson(reader, composition);
                            if (newItem == null) continue;
                            items.add(newItem);
                        }
                        reader.endArray();
                        continue block8;
                    }
                }
                reader.skipValue();
            }
            return new ShapeGroup(name, items);
        }
    }
}

