/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.animation.ValueAnimator;
import android.support.annotation.FloatRange;
import com.airbnb.lottie.utils.MiscUtils;

public class LottieValueAnimator
extends ValueAnimator {
    private boolean systemAnimationsAreDisabled = false;
    private float compositionDuration;
    private float speed = 1.0f;
    @FloatRange(from=0.0, to=1.0)
    private float value = 0.0f;
    @FloatRange(from=0.0, to=1.0)
    private float minValue = 0.0f;
    @FloatRange(from=0.0, to=1.0)
    private float maxValue = 1.0f;

    public LottieValueAnimator() {
        this.setInterpolator(null);
        this.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (!LottieValueAnimator.this.systemAnimationsAreDisabled) {
                    LottieValueAnimator.this.value = ((Float)animation.getAnimatedValue()).floatValue();
                }
            }
        });
        this.updateValues();
    }

    public void systemAnimationsAreDisabled() {
        this.systemAnimationsAreDisabled = true;
    }

    public void setCompositionDuration(float compositionDuration) {
        this.compositionDuration = compositionDuration;
        this.updateValues();
    }

    public void setValue(@FloatRange(from=0.0, to=1.0) float value) {
        this.value = value = MiscUtils.clamp(value, this.minValue, this.maxValue);
        float distFromStart = this.isReversed() ? this.maxValue - value : value - this.minValue;
        float range = Math.abs(this.maxValue - this.minValue);
        float animatedPercentage = distFromStart / range;
        if (this.getDuration() > 0L) {
            this.setCurrentPlayTime(Math.round((float)this.getDuration() * animatedPercentage));
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setMinAndMaxValues(@FloatRange(from=0.0, to=1.0) float minValue, @FloatRange(from=0.0, to=1.0) float maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.updateValues();
    }

    public void setMinValue(@FloatRange(from=0.0, to=1.0) float minValue) {
        if (minValue >= this.maxValue) {
            throw new IllegalArgumentException("Min value must be smaller then max value.");
        }
        this.minValue = minValue;
        this.updateValues();
    }

    public float getMinValue() {
        return this.minValue;
    }

    public void setMaxValue(@FloatRange(from=0.0, to=1.0) float maxValue) {
        if (maxValue <= this.minValue) {
            throw new IllegalArgumentException("Max value must be greater than min value.");
        }
        this.maxValue = maxValue;
        this.updateValues();
    }

    public void reverseAnimationSpeed() {
        this.setSpeed(-this.getSpeed());
    }

    public void setSpeed(float speed) {
        this.speed = speed;
        this.updateValues();
    }

    public float getSpeed() {
        return this.speed;
    }

    public void playAnimation() {
        this.start();
        this.setValue(this.isReversed() ? this.maxValue : this.minValue);
    }

    public void endAnimation() {
        this.end();
    }

    public void pauseAnimation() {
        float value = this.value;
        this.cancel();
        this.setValue(value);
    }

    public void resumeAnimation() {
        float value = this.value;
        if (this.isReversed() && this.value == this.minValue) {
            value = this.maxValue;
        } else if (!this.isReversed() && this.value == this.maxValue) {
            value = this.minValue;
        }
        this.start();
        this.setValue(value);
    }

    private boolean isReversed() {
        return this.speed < 0.0f;
    }

    private void updateValues() {
        this.setDuration((long)(this.compositionDuration * (this.maxValue - this.minValue) / Math.abs(this.speed)));
        this.setFloatValues(new float[]{this.speed < 0.0f ? this.maxValue : this.minValue, this.speed < 0.0f ? this.minValue : this.maxValue});
        this.setValue(this.value);
    }
}

