/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.value;

import android.util.JsonReader;
import android.util.JsonToken;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import java.io.IOException;

public class ScaleXY {
    private final float scaleX;
    private final float scaleY;

    public ScaleXY(float sx, float sy) {
        this.scaleX = sx;
        this.scaleY = sy;
    }

    public ScaleXY() {
        this(1.0f, 1.0f);
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public String toString() {
        return this.getScaleX() + "x" + this.getScaleY();
    }

    public static class Factory
    implements AnimatableValue.Factory<ScaleXY> {
        public static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        @Override
        public ScaleXY valueFromObject(JsonReader reader, float scale) throws IOException {
            boolean isArray;
            boolean bl = isArray = reader.peek() == JsonToken.BEGIN_ARRAY;
            if (isArray) {
                reader.beginArray();
            }
            float sx = (float)reader.nextDouble();
            float sy = (float)reader.nextDouble();
            while (reader.hasNext()) {
                reader.skipValue();
            }
            if (isArray) {
                reader.endArray();
            }
            return new ScaleXY(sx / 100.0f * scale, sy / 100.0f * scale);
        }
    }
}

