/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.network;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.core.util.Pair;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieCompositionFactory;
import com.airbnb.lottie.LottieResult;
import com.airbnb.lottie.LottieTask;
import com.airbnb.lottie.network.FileExtension;
import com.airbnb.lottie.network.NetworkCache;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.zip.ZipInputStream;

public class NetworkFetcher {
    private final Context appContext;
    private final String url;
    private final NetworkCache networkCache;

    public static LottieTask<LottieComposition> fetch(Context context, String url) {
        return new NetworkFetcher(context, url).fetch();
    }

    public static LottieResult<LottieComposition> fetchSync(Context context, String url) {
        return new NetworkFetcher(context, url).fetchSync();
    }

    private NetworkFetcher(Context context, String url) {
        this.appContext = context.getApplicationContext();
        this.url = url;
        this.networkCache = new NetworkCache(this.appContext, url);
    }

    private LottieTask<LottieComposition> fetch() {
        return new LottieTask<LottieComposition>(new Callable<LottieResult<LottieComposition>>(){

            @Override
            public LottieResult<LottieComposition> call() throws Exception {
                return NetworkFetcher.this.fetchSync();
            }
        });
    }

    @WorkerThread
    public LottieResult<LottieComposition> fetchSync() {
        LottieComposition result = this.fetchFromCache();
        if (result != null) {
            return new LottieResult<LottieComposition>(result);
        }
        L.debug("Animation for " + this.url + " not found in cache. Fetching from network.");
        return this.fetchFromNetwork();
    }

    @Nullable
    @WorkerThread
    private LottieComposition fetchFromCache() {
        Pair<FileExtension, InputStream> cacheResult = this.networkCache.fetch();
        if (cacheResult == null) {
            return null;
        }
        FileExtension extension = (FileExtension)((Object)cacheResult.first);
        InputStream inputStream = (InputStream)cacheResult.second;
        LottieResult<LottieComposition> result = extension == FileExtension.Zip ? LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(inputStream), this.url) : LottieCompositionFactory.fromJsonInputStreamSync(inputStream, this.url);
        if (result.getValue() != null) {
            return result.getValue();
        }
        return null;
    }

    @WorkerThread
    private LottieResult<LottieComposition> fetchFromNetwork() {
        try {
            return this.fetchFromNetworkInternal();
        }
        catch (IOException e) {
            return new LottieResult<LottieComposition>(e);
        }
    }

    @WorkerThread
    private LottieResult fetchFromNetworkInternal() throws IOException {
        LottieResult<LottieComposition> result;
        FileExtension extension;
        L.debug("Fetching " + this.url);
        HttpURLConnection connection = (HttpURLConnection)new URL(this.url).openConnection();
        connection.setRequestMethod("GET");
        connection.connect();
        if (connection.getErrorStream() != null || connection.getResponseCode() != 200) {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
            StringBuilder error = new StringBuilder();
            while ((line = r.readLine()) != null) {
                error.append(line).append('\n');
            }
            return new LottieResult(new IllegalArgumentException("Unable to fetch " + this.url + ". Failed with " + connection.getResponseCode() + "\n" + error));
        }
        switch (connection.getContentType()) {
            case "application/zip": {
                L.debug("Handling zip response.");
                extension = FileExtension.Zip;
                File file = this.networkCache.writeTempCacheFile(connection.getInputStream(), extension);
                result = LottieCompositionFactory.fromZipStreamSync(new ZipInputStream(new FileInputStream(file)), this.url);
                break;
            }
            default: {
                L.debug("Received json response.");
                extension = FileExtension.Json;
                File file = this.networkCache.writeTempCacheFile(connection.getInputStream(), extension);
                result = LottieCompositionFactory.fromJsonInputStreamSync(new FileInputStream(new File(file.getAbsolutePath())), this.url);
            }
        }
        if (result.getValue() != null) {
            this.networkCache.renameTempFile(extension);
        }
        L.debug("Completed fetch from network. Success: " + (result.getValue() != null));
        return result;
    }
}

