/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import com.airbnb.lottie.model.DocumentData;
import com.airbnb.lottie.parser.JsonUtils;
import com.airbnb.lottie.parser.ValueParser;
import java.io.IOException;

public class DocumentDataParser
implements ValueParser<DocumentData> {
    public static final DocumentDataParser INSTANCE = new DocumentDataParser();

    private DocumentDataParser() {
    }

    @Override
    public DocumentData parse(JsonReader reader, float scale) throws IOException {
        String text = null;
        String fontName = null;
        double size = 0.0;
        DocumentData.Justification justification = DocumentData.Justification.CENTER;
        int tracking = 0;
        double lineHeight = 0.0;
        double baselineShift = 0.0;
        int fillColor = 0;
        int strokeColor = 0;
        double strokeWidth = 0.0;
        boolean strokeOverFill = true;
        reader.beginObject();
        block26: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "t": {
                    text = reader.nextString();
                    continue block26;
                }
                case "f": {
                    fontName = reader.nextString();
                    continue block26;
                }
                case "s": {
                    size = reader.nextDouble();
                    continue block26;
                }
                case "j": {
                    int justificationInt = reader.nextInt();
                    if (justificationInt > DocumentData.Justification.CENTER.ordinal() || justificationInt < 0) {
                        justification = DocumentData.Justification.CENTER;
                        continue block26;
                    }
                    justification = DocumentData.Justification.values()[justificationInt];
                    continue block26;
                }
                case "tr": {
                    tracking = reader.nextInt();
                    continue block26;
                }
                case "lh": {
                    lineHeight = reader.nextDouble();
                    continue block26;
                }
                case "ls": {
                    baselineShift = reader.nextDouble();
                    continue block26;
                }
                case "fc": {
                    fillColor = JsonUtils.jsonToColor(reader);
                    continue block26;
                }
                case "sc": {
                    strokeColor = JsonUtils.jsonToColor(reader);
                    continue block26;
                }
                case "sw": {
                    strokeWidth = reader.nextDouble();
                    continue block26;
                }
                case "of": {
                    strokeOverFill = reader.nextBoolean();
                    continue block26;
                }
            }
            reader.skipValue();
        }
        reader.endObject();
        return new DocumentData(text, fontName, size, justification, tracking, lineHeight, baselineShift, fillColor, strokeColor, strokeWidth, strokeOverFill);
    }
}

