/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.util.JsonReader;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableGradientColorValue;
import com.airbnb.lottie.model.animatable.AnimatableIntegerValue;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.content.GradientStroke;
import com.airbnb.lottie.model.content.GradientType;
import com.airbnb.lottie.model.content.ShapeStroke;
import com.airbnb.lottie.parser.AnimatableValueParser;
import java.io.IOException;
import java.util.ArrayList;

class GradientStrokeParser {
    private GradientStrokeParser() {
    }

    static GradientStroke parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableGradientColorValue color = null;
        AnimatableIntegerValue opacity = null;
        GradientType gradientType = null;
        AnimatablePointValue startPoint = null;
        AnimatablePointValue endPoint = null;
        AnimatableFloatValue width = null;
        ShapeStroke.LineCapType capType = null;
        ShapeStroke.LineJoinType joinType = null;
        AnimatableFloatValue offset = null;
        float miterLimit = 0.0f;
        boolean hidden = false;
        ArrayList<AnimatableFloatValue> lineDashPattern = new ArrayList<AnimatableFloatValue>();
        block44: while (reader.hasNext()) {
            switch (reader.nextName()) {
                case "nm": {
                    name = reader.nextString();
                    continue block44;
                }
                case "g": {
                    int points = -1;
                    reader.beginObject();
                    block45: while (reader.hasNext()) {
                        switch (reader.nextName()) {
                            case "p": {
                                points = reader.nextInt();
                                continue block45;
                            }
                            case "k": {
                                color = AnimatableValueParser.parseGradientColor(reader, composition, points);
                                continue block45;
                            }
                        }
                        reader.skipValue();
                    }
                    reader.endObject();
                    continue block44;
                }
                case "o": {
                    opacity = AnimatableValueParser.parseInteger(reader, composition);
                    continue block44;
                }
                case "t": {
                    gradientType = reader.nextInt() == 1 ? GradientType.LINEAR : GradientType.RADIAL;
                    continue block44;
                }
                case "s": {
                    startPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block44;
                }
                case "e": {
                    endPoint = AnimatableValueParser.parsePoint(reader, composition);
                    continue block44;
                }
                case "w": {
                    width = AnimatableValueParser.parseFloat(reader, composition);
                    continue block44;
                }
                case "lc": {
                    capType = ShapeStroke.LineCapType.values()[reader.nextInt() - 1];
                    continue block44;
                }
                case "lj": {
                    joinType = ShapeStroke.LineJoinType.values()[reader.nextInt() - 1];
                    continue block44;
                }
                case "ml": {
                    miterLimit = (float)reader.nextDouble();
                    continue block44;
                }
                case "hd": {
                    hidden = reader.nextBoolean();
                    continue block44;
                }
                case "d": {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        String n = null;
                        AnimatableFloatValue val = null;
                        reader.beginObject();
                        block47: while (reader.hasNext()) {
                            switch (reader.nextName()) {
                                case "n": {
                                    n = reader.nextString();
                                    continue block47;
                                }
                                case "v": {
                                    val = AnimatableValueParser.parseFloat(reader, composition);
                                    continue block47;
                                }
                            }
                            reader.skipValue();
                        }
                        reader.endObject();
                        if (n.equals("o")) {
                            offset = val;
                            continue;
                        }
                        if (!n.equals("d") && !n.equals("g")) continue;
                        composition.setHasDashPattern(true);
                        lineDashPattern.add(val);
                    }
                    reader.endArray();
                    if (lineDashPattern.size() != 1) continue block44;
                    lineDashPattern.add((AnimatableFloatValue)lineDashPattern.get(0));
                    continue block44;
                }
            }
            reader.skipValue();
        }
        return new GradientStroke(name, gradientType, color, opacity, startPoint, endPoint, width, capType, joinType, miterLimit, lineDashPattern, offset, hidden);
    }
}

