/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.network.LottieNetworkCacheProvider;
import com.airbnb.lottie.network.LottieNetworkFetcher;
import java.io.File;

public class LottieConfig {
    @Nullable
    final LottieNetworkFetcher networkFetcher;
    @Nullable
    final LottieNetworkCacheProvider cacheProvider;
    final boolean enableSystraceMarkers;

    private LottieConfig(@Nullable LottieNetworkFetcher networkFetcher, @Nullable LottieNetworkCacheProvider cacheProvider, boolean enableSystraceMarkers) {
        this.networkFetcher = networkFetcher;
        this.cacheProvider = cacheProvider;
        this.enableSystraceMarkers = enableSystraceMarkers;
    }

    public static final class Builder {
        @Nullable
        private LottieNetworkFetcher networkFetcher;
        @Nullable
        private LottieNetworkCacheProvider cacheProvider;
        private boolean enableSystraceMarkers = false;

        @NonNull
        public Builder setNetworkFetcher(@NonNull LottieNetworkFetcher fetcher) {
            this.networkFetcher = fetcher;
            return this;
        }

        @NonNull
        public Builder setNetworkCacheDir(final @NonNull File file) {
            if (this.cacheProvider != null) {
                throw new IllegalStateException("There is already a cache provider!");
            }
            this.cacheProvider = new LottieNetworkCacheProvider(){

                @Override
                @NonNull
                public File getCacheDir() {
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("cache file must be a directory");
                    }
                    return file;
                }
            };
            return this;
        }

        @NonNull
        public Builder setNetworkCacheProvider(final @NonNull LottieNetworkCacheProvider fileCacheProvider) {
            if (this.cacheProvider != null) {
                throw new IllegalStateException("There is already a cache provider!");
            }
            this.cacheProvider = new LottieNetworkCacheProvider(){

                @Override
                @NonNull
                public File getCacheDir() {
                    File file = fileCacheProvider.getCacheDir();
                    if (!file.isDirectory()) {
                        throw new IllegalArgumentException("cache file must be a directory");
                    }
                    return file;
                }
            };
            return this;
        }

        @NonNull
        public Builder setEnableSystraceMarkers(boolean enable) {
            this.enableSystraceMarkers = enable;
            return this;
        }

        @NonNull
        public LottieConfig build() {
            return new LottieConfig(this.networkFetcher, this.cacheProvider, this.enableSystraceMarkers);
        }
    }
}

