/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.manager;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Base64;
import android.view.View;
import androidx.annotation.Nullable;
import com.airbnb.lottie.ImageAssetDelegate;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.utils.Logger;
import com.airbnb.lottie.utils.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ImageAssetManager {
    private static final Object bitmapHashLock = new Object();
    private final Context context;
    private final String imagesFolder;
    @Nullable
    private ImageAssetDelegate delegate;
    private final Map<String, LottieImageAsset> imageAssets;

    public ImageAssetManager(Drawable.Callback callback, String imagesFolder, ImageAssetDelegate delegate, Map<String, LottieImageAsset> imageAssets) {
        this.imagesFolder = !TextUtils.isEmpty((CharSequence)imagesFolder) && imagesFolder.charAt(imagesFolder.length() - 1) != '/' ? imagesFolder + '/' : imagesFolder;
        if (!(callback instanceof View)) {
            Logger.warning("LottieDrawable must be inside of a view for images to work.");
            this.imageAssets = new HashMap<String, LottieImageAsset>();
            this.context = null;
            return;
        }
        this.context = ((View)callback).getContext();
        this.imageAssets = imageAssets;
        this.setDelegate(delegate);
    }

    public void setDelegate(@Nullable ImageAssetDelegate assetDelegate) {
        this.delegate = assetDelegate;
    }

    @Nullable
    public Bitmap updateBitmap(String id, @Nullable Bitmap bitmap) {
        if (bitmap == null) {
            LottieImageAsset asset = this.imageAssets.get(id);
            Bitmap ret = asset.getBitmap();
            asset.setBitmap(null);
            return ret;
        }
        Bitmap prevBitmap = this.imageAssets.get(id).getBitmap();
        this.putBitmap(id, bitmap);
        return prevBitmap;
    }

    @Nullable
    public Bitmap bitmapForId(String id) {
        InputStream is;
        LottieImageAsset asset = this.imageAssets.get(id);
        if (asset == null) {
            return null;
        }
        Bitmap bitmap = asset.getBitmap();
        if (bitmap != null) {
            return bitmap;
        }
        if (this.delegate != null) {
            bitmap = this.delegate.fetchBitmap(asset);
            if (bitmap != null) {
                this.putBitmap(id, bitmap);
            }
            return bitmap;
        }
        String filename = asset.getFileName();
        BitmapFactory.Options opts = new BitmapFactory.Options();
        opts.inScaled = true;
        opts.inDensity = 160;
        if (filename.startsWith("data:") && filename.indexOf("base64,") > 0) {
            byte[] data;
            try {
                data = Base64.decode((String)filename.substring(filename.indexOf(44) + 1), (int)0);
            }
            catch (IllegalArgumentException e) {
                Logger.warning("data URL did not have correct base64 format.", e);
                return null;
            }
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            return this.putBitmap(id, bitmap);
        }
        try {
            if (TextUtils.isEmpty((CharSequence)this.imagesFolder)) {
                throw new IllegalStateException("You must set an images folder before loading an image. Set it with LottieComposition#setImagesFolder or LottieDrawable#setImagesFolder");
            }
            is = this.context.getAssets().open(this.imagesFolder + filename);
        }
        catch (IOException e) {
            Logger.warning("Unable to open asset.", e);
            return null;
        }
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)opts);
        }
        catch (IllegalArgumentException e) {
            Logger.warning("Unable to decode image.", e);
            return null;
        }
        bitmap = Utils.resizeBitmapIfNeeded(bitmap, asset.getWidth(), asset.getHeight());
        return this.putBitmap(id, bitmap);
    }

    public boolean hasSameContext(Context context) {
        return context == null && this.context == null || this.context.equals(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap putBitmap(String key, @Nullable Bitmap bitmap) {
        Object object = bitmapHashLock;
        synchronized (object) {
            this.imageAssets.get(key).setBitmap(bitmap);
            return bitmap;
        }
    }
}

