/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatablePointValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.CircleShape;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class CircleShapeParser {
    private static JsonReader.Options NAMES = JsonReader.Options.of("nm", "p", "s", "hd", "d");

    private CircleShapeParser() {
    }

    static CircleShape parse(JsonReader reader, LottieComposition composition, int d) throws IOException {
        String name = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatablePointValue size = null;
        boolean reversed = d == 3;
        boolean hidden = false;
        block7: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block7;
                }
                case 1: {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block7;
                }
                case 2: {
                    size = AnimatableValueParser.parsePoint(reader, composition);
                    continue block7;
                }
                case 3: {
                    hidden = reader.nextBoolean();
                    continue block7;
                }
                case 4: {
                    reversed = reader.nextInt() == 3;
                    continue block7;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        return new CircleShape(name, position, size, reversed, hidden);
    }
}

