/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.L;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseKeyframeAnimation<K, A> {
    final List<AnimationListener> listeners = new ArrayList<AnimationListener>(1);
    private boolean isDiscrete = false;
    private final KeyframesWrapper<K> keyframesWrapper;
    protected float progress = 0.0f;
    @Nullable
    protected LottieValueCallback<A> valueCallback;
    @Nullable
    private A cachedGetValue = null;
    private float cachedStartDelayProgress = -1.0f;
    private float cachedEndProgress = -1.0f;

    BaseKeyframeAnimation(List<? extends Keyframe<K>> keyframes) {
        this.keyframesWrapper = BaseKeyframeAnimation.wrap(keyframes);
    }

    public void setIsDiscrete() {
        this.isDiscrete = true;
    }

    public void addUpdateListener(AnimationListener listener) {
        this.listeners.add(listener);
    }

    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (this.keyframesWrapper.isEmpty()) {
            return;
        }
        if (progress < this.getStartDelayProgress()) {
            progress = this.getStartDelayProgress();
        } else if (progress > this.getEndProgress()) {
            progress = this.getEndProgress();
        }
        if (progress == this.progress) {
            return;
        }
        this.progress = progress;
        if (this.keyframesWrapper.isValueChanged(progress)) {
            this.notifyListeners();
        }
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onValueChanged();
        }
    }

    protected Keyframe<K> getCurrentKeyframe() {
        L.beginSection("BaseKeyframeAnimation#getCurrentKeyframe");
        Keyframe<K> keyframe = this.keyframesWrapper.getCurrentKeyframe();
        L.endSection("BaseKeyframeAnimation#getCurrentKeyframe");
        return keyframe;
    }

    float getLinearCurrentKeyframeProgress() {
        if (this.isDiscrete) {
            return 0.0f;
        }
        Keyframe<K> keyframe = this.getCurrentKeyframe();
        if (keyframe.isStatic()) {
            return 0.0f;
        }
        float progressIntoFrame = this.progress - keyframe.getStartProgress();
        float keyframeProgress = keyframe.getEndProgress() - keyframe.getStartProgress();
        return progressIntoFrame / keyframeProgress;
    }

    protected float getInterpolatedCurrentKeyframeProgress() {
        Keyframe<K> keyframe = this.getCurrentKeyframe();
        if (keyframe.isStatic()) {
            return 0.0f;
        }
        return keyframe.interpolator.getInterpolation(this.getLinearCurrentKeyframeProgress());
    }

    @FloatRange(from=0.0, to=1.0)
    private float getStartDelayProgress() {
        if (this.cachedStartDelayProgress == -1.0f) {
            this.cachedStartDelayProgress = this.keyframesWrapper.getStartDelayProgress();
        }
        return this.cachedStartDelayProgress;
    }

    @FloatRange(from=0.0, to=1.0)
    float getEndProgress() {
        if (this.cachedEndProgress == -1.0f) {
            this.cachedEndProgress = this.keyframesWrapper.getEndProgress();
        }
        return this.cachedEndProgress;
    }

    public A getValue() {
        A value;
        float linearProgress = this.getLinearCurrentKeyframeProgress();
        if (this.valueCallback == null && this.keyframesWrapper.isCachedValueEnabled(linearProgress)) {
            return this.cachedGetValue;
        }
        Keyframe<K> keyframe = this.getCurrentKeyframe();
        if (keyframe.xInterpolator != null && keyframe.yInterpolator != null) {
            float xProgress = keyframe.xInterpolator.getInterpolation(linearProgress);
            float yProgress = keyframe.yInterpolator.getInterpolation(linearProgress);
            value = this.getValue(keyframe, linearProgress, xProgress, yProgress);
        } else {
            float progress = this.getInterpolatedCurrentKeyframeProgress();
            value = this.getValue(keyframe, progress);
        }
        this.cachedGetValue = value;
        return value;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setValueCallback(@Nullable LottieValueCallback<A> valueCallback) {
        if (this.valueCallback != null) {
            this.valueCallback.setAnimation(null);
        }
        this.valueCallback = valueCallback;
        if (valueCallback != null) {
            valueCallback.setAnimation(this);
        }
    }

    abstract A getValue(Keyframe<K> var1, float var2);

    protected A getValue(Keyframe<K> keyframe, float linearKeyframeProgress, float xKeyframeProgress, float yKeyframeProgress) {
        throw new UnsupportedOperationException("This animation does not support split dimensions!");
    }

    private static <T> KeyframesWrapper<T> wrap(List<? extends Keyframe<T>> keyframes) {
        if (keyframes.isEmpty()) {
            return new EmptyKeyframeWrapper();
        }
        if (keyframes.size() == 1) {
            return new SingleKeyframeWrapper(keyframes);
        }
        return new KeyframesWrapperImpl(keyframes);
    }

    private static final class KeyframesWrapperImpl<T>
    implements KeyframesWrapper<T> {
        private final List<? extends Keyframe<T>> keyframes;
        @NonNull
        private Keyframe<T> currentKeyframe;
        private Keyframe<T> cachedCurrentKeyframe = null;
        private float cachedInterpolatedProgress = -1.0f;

        KeyframesWrapperImpl(List<? extends Keyframe<T>> keyframes) {
            this.keyframes = keyframes;
            this.currentKeyframe = this.findKeyframe(0.0f);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isValueChanged(float progress) {
            if (this.currentKeyframe.containsProgress(progress)) {
                return !this.currentKeyframe.isStatic();
            }
            this.currentKeyframe = this.findKeyframe(progress);
            return true;
        }

        private Keyframe<T> findKeyframe(float progress) {
            Keyframe<T> keyframe = this.keyframes.get(this.keyframes.size() - 1);
            if (progress >= keyframe.getStartProgress()) {
                return keyframe;
            }
            for (int i = this.keyframes.size() - 2; i >= 1; --i) {
                keyframe = this.keyframes.get(i);
                if (this.currentKeyframe == keyframe || !keyframe.containsProgress(progress)) continue;
                return keyframe;
            }
            return this.keyframes.get(0);
        }

        @Override
        @NonNull
        public Keyframe<T> getCurrentKeyframe() {
            return this.currentKeyframe;
        }

        @Override
        public float getStartDelayProgress() {
            return this.keyframes.get(0).getStartProgress();
        }

        @Override
        public float getEndProgress() {
            return this.keyframes.get(this.keyframes.size() - 1).getEndProgress();
        }

        @Override
        public boolean isCachedValueEnabled(float progress) {
            if (this.cachedCurrentKeyframe == this.currentKeyframe && this.cachedInterpolatedProgress == progress) {
                return true;
            }
            this.cachedCurrentKeyframe = this.currentKeyframe;
            this.cachedInterpolatedProgress = progress;
            return false;
        }
    }

    private static final class SingleKeyframeWrapper<T>
    implements KeyframesWrapper<T> {
        @NonNull
        private final Keyframe<T> keyframe;
        private float cachedInterpolatedProgress = -1.0f;

        SingleKeyframeWrapper(List<? extends Keyframe<T>> keyframes) {
            this.keyframe = keyframes.get(0);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isValueChanged(float progress) {
            return !this.keyframe.isStatic();
        }

        @Override
        public Keyframe<T> getCurrentKeyframe() {
            return this.keyframe;
        }

        @Override
        public float getStartDelayProgress() {
            return this.keyframe.getStartProgress();
        }

        @Override
        public float getEndProgress() {
            return this.keyframe.getEndProgress();
        }

        @Override
        public boolean isCachedValueEnabled(float progress) {
            if (this.cachedInterpolatedProgress == progress) {
                return true;
            }
            this.cachedInterpolatedProgress = progress;
            return false;
        }
    }

    private static final class EmptyKeyframeWrapper<T>
    implements KeyframesWrapper<T> {
        private EmptyKeyframeWrapper() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean isValueChanged(float progress) {
            return false;
        }

        @Override
        public Keyframe<T> getCurrentKeyframe() {
            throw new IllegalStateException("not implemented");
        }

        @Override
        public float getStartDelayProgress() {
            return 0.0f;
        }

        @Override
        public float getEndProgress() {
            return 1.0f;
        }

        @Override
        public boolean isCachedValueEnabled(float progress) {
            throw new IllegalStateException("not implemented");
        }
    }

    private static interface KeyframesWrapper<T> {
        public boolean isEmpty();

        public boolean isValueChanged(float var1);

        public Keyframe<T> getCurrentKeyframe();

        @FloatRange(from=0.0, to=1.0)
        public float getStartDelayProgress();

        @FloatRange(from=0.0, to=1.0)
        public float getEndProgress();

        public boolean isCachedValueEnabled(float var1);
    }

    public static interface AnimationListener {
        public void onValueChanged();
    }
}

