/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import android.graphics.PointF;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableValue;
import com.airbnb.lottie.model.content.PolystarShape;
import com.airbnb.lottie.parser.AnimatablePathValueParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class PolystarShapeParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("nm", "sy", "pt", "p", "r", "or", "os", "ir", "is", "hd", "d");

    private PolystarShapeParser() {
    }

    static PolystarShape parse(JsonReader reader, LottieComposition composition, int d) throws IOException {
        boolean reversed;
        String name = null;
        PolystarShape.Type type = null;
        AnimatableFloatValue points = null;
        AnimatableValue<PointF, PointF> position = null;
        AnimatableFloatValue rotation = null;
        AnimatableFloatValue outerRadius = null;
        AnimatableFloatValue outerRoundedness = null;
        AnimatableFloatValue innerRadius = null;
        AnimatableFloatValue innerRoundedness = null;
        boolean hidden = false;
        boolean bl = reversed = d == 3;
        block13: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block13;
                }
                case 1: {
                    type = PolystarShape.Type.forValue(reader.nextInt());
                    continue block13;
                }
                case 2: {
                    points = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block13;
                }
                case 3: {
                    position = AnimatablePathValueParser.parseSplitPath(reader, composition);
                    continue block13;
                }
                case 4: {
                    rotation = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block13;
                }
                case 5: {
                    outerRadius = AnimatableValueParser.parseFloat(reader, composition);
                    continue block13;
                }
                case 6: {
                    outerRoundedness = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block13;
                }
                case 7: {
                    innerRadius = AnimatableValueParser.parseFloat(reader, composition);
                    continue block13;
                }
                case 8: {
                    innerRoundedness = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block13;
                }
                case 9: {
                    hidden = reader.nextBoolean();
                    continue block13;
                }
                case 10: {
                    reversed = reader.nextInt() == 3;
                    continue block13;
                }
            }
            reader.skipName();
            reader.skipValue();
        }
        return new PolystarShape(name, type, points, position, rotation, innerRadius, outerRadius, innerRoundedness, outerRoundedness, hidden, reversed);
    }
}

