/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.animation.keyframe;

import android.graphics.PointF;
import androidx.annotation.Nullable;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.value.Keyframe;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.Collections;

public class SplitDimensionPathKeyframeAnimation
extends BaseKeyframeAnimation<PointF, PointF> {
    private final PointF point = new PointF();
    private final PointF pointWithCallbackValues = new PointF();
    private final BaseKeyframeAnimation<Float, Float> xAnimation;
    private final BaseKeyframeAnimation<Float, Float> yAnimation;
    @Nullable
    protected LottieValueCallback<Float> xValueCallback;
    @Nullable
    protected LottieValueCallback<Float> yValueCallback;

    public SplitDimensionPathKeyframeAnimation(BaseKeyframeAnimation<Float, Float> xAnimation, BaseKeyframeAnimation<Float, Float> yAnimation) {
        super(Collections.emptyList());
        this.xAnimation = xAnimation;
        this.yAnimation = yAnimation;
        this.setProgress(this.getProgress());
    }

    public void setXValueCallback(@Nullable LottieValueCallback<Float> xValueCallback) {
        if (this.xValueCallback != null) {
            this.xValueCallback.setAnimation(null);
        }
        this.xValueCallback = xValueCallback;
        if (xValueCallback != null) {
            xValueCallback.setAnimation(this);
        }
    }

    public void setYValueCallback(@Nullable LottieValueCallback<Float> yValueCallback) {
        if (this.yValueCallback != null) {
            this.yValueCallback.setAnimation(null);
        }
        this.yValueCallback = yValueCallback;
        if (yValueCallback != null) {
            yValueCallback.setAnimation(this);
        }
    }

    @Override
    public void setProgress(float progress) {
        this.xAnimation.setProgress(progress);
        this.yAnimation.setProgress(progress);
        this.point.set(this.xAnimation.getValue().floatValue(), this.yAnimation.getValue().floatValue());
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((BaseKeyframeAnimation.AnimationListener)this.listeners.get(i)).onValueChanged();
        }
    }

    @Override
    public PointF getValue() {
        return this.getValue((Keyframe<PointF>)null, 0.0f);
    }

    @Override
    PointF getValue(Keyframe<PointF> keyframe, float keyframeProgress) {
        Keyframe<Float> yKeyframe;
        Float endFrame;
        float progress;
        Keyframe<Float> xKeyframe;
        Float xCallbackValue = null;
        Float yCallbackValue = null;
        if (this.xValueCallback != null && (xKeyframe = this.xAnimation.getCurrentKeyframe()) != null) {
            progress = this.xAnimation.getInterpolatedCurrentKeyframeProgress();
            endFrame = xKeyframe.endFrame;
            xCallbackValue = this.xValueCallback.getValueInternal(xKeyframe.startFrame, endFrame == null ? xKeyframe.startFrame : endFrame.floatValue(), (Float)xKeyframe.startValue, (Float)xKeyframe.endValue, keyframeProgress, keyframeProgress, progress);
        }
        if (this.yValueCallback != null && (yKeyframe = this.yAnimation.getCurrentKeyframe()) != null) {
            progress = this.yAnimation.getInterpolatedCurrentKeyframeProgress();
            endFrame = yKeyframe.endFrame;
            yCallbackValue = this.yValueCallback.getValueInternal(yKeyframe.startFrame, endFrame == null ? yKeyframe.startFrame : endFrame.floatValue(), (Float)yKeyframe.startValue, (Float)yKeyframe.endValue, keyframeProgress, keyframeProgress, progress);
        }
        if (xCallbackValue == null) {
            this.pointWithCallbackValues.set(this.point.x, 0.0f);
        } else {
            this.pointWithCallbackValues.set(xCallbackValue.floatValue(), 0.0f);
        }
        if (yCallbackValue == null) {
            this.pointWithCallbackValues.set(this.pointWithCallbackValues.x, this.point.y);
        } else {
            this.pointWithCallbackValues.set(this.pointWithCallbackValues.x, yCallbackValue.floatValue());
        }
        return this.pointWithCallbackValues;
    }
}

