/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.parser;

import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.animatable.AnimatableTransform;
import com.airbnb.lottie.model.content.Repeater;
import com.airbnb.lottie.parser.AnimatableTransformParser;
import com.airbnb.lottie.parser.AnimatableValueParser;
import com.airbnb.lottie.parser.moshi.JsonReader;
import java.io.IOException;

class RepeaterParser {
    private static final JsonReader.Options NAMES = JsonReader.Options.of("nm", "c", "o", "tr", "hd");

    private RepeaterParser() {
    }

    static Repeater parse(JsonReader reader, LottieComposition composition) throws IOException {
        String name = null;
        AnimatableFloatValue copies = null;
        AnimatableFloatValue offset = null;
        AnimatableTransform transform = null;
        boolean hidden = false;
        block7: while (reader.hasNext()) {
            switch (reader.selectName(NAMES)) {
                case 0: {
                    name = reader.nextString();
                    continue block7;
                }
                case 1: {
                    copies = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block7;
                }
                case 2: {
                    offset = AnimatableValueParser.parseFloat(reader, composition, false);
                    continue block7;
                }
                case 3: {
                    transform = AnimatableTransformParser.parse(reader, composition);
                    continue block7;
                }
                case 4: {
                    hidden = reader.nextBoolean();
                    continue block7;
                }
            }
            reader.skipValue();
        }
        return new Repeater(name, copies, offset, transform, hidden);
    }
}

