/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieImageAsset;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.LPaint;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.DropShadowKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.utils.DropShadow;
import com.airbnb.lottie.utils.OffscreenLayer;
import com.airbnb.lottie.utils.Utils;
import com.airbnb.lottie.value.LottieValueCallback;

public class ImageLayer
extends BaseLayer {
    private final Paint paint = new LPaint(3);
    private final Rect src = new Rect();
    private final Rect dst = new Rect();
    private final RectF layerBounds = new RectF();
    @Nullable
    private final LottieImageAsset lottieImageAsset;
    @Nullable
    private BaseKeyframeAnimation<ColorFilter, ColorFilter> colorFilterAnimation;
    @Nullable
    private BaseKeyframeAnimation<Bitmap, Bitmap> imageAnimation;
    @Nullable
    private DropShadowKeyframeAnimation dropShadowAnimation;
    @Nullable
    private OffscreenLayer offscreenLayer;
    @Nullable
    private OffscreenLayer.ComposeOp offscreenOp;

    ImageLayer(LottieDrawable lottieDrawable, Layer layerModel) {
        super(lottieDrawable, layerModel);
        this.lottieImageAsset = lottieDrawable.getLottieImageAssetForId(layerModel.getRefId());
        if (this.getDropShadowEffect() != null) {
            this.dropShadowAnimation = new DropShadowKeyframeAnimation(this, this, this.getDropShadowEffect());
        }
    }

    @Override
    public void drawLayer(@NonNull Canvas canvas, Matrix parentMatrix, int parentAlpha, @Nullable DropShadow parentShadowToApply) {
        Bitmap bitmap = this.getBitmap();
        if (bitmap == null || bitmap.isRecycled() || this.lottieImageAsset == null) {
            return;
        }
        float density = Utils.dpScale();
        this.paint.setAlpha(parentAlpha);
        if (this.colorFilterAnimation != null) {
            this.paint.setColorFilter(this.colorFilterAnimation.getValue());
        }
        DropShadow shadowToApply = this.dropShadowAnimation != null ? this.dropShadowAnimation.evaluate(parentMatrix, parentAlpha) : parentShadowToApply;
        this.src.set(0, 0, bitmap.getWidth(), bitmap.getHeight());
        if (this.lottieDrawable.getMaintainOriginalImageBounds()) {
            this.dst.set(0, 0, (int)((float)this.lottieImageAsset.getWidth() * density), (int)((float)this.lottieImageAsset.getHeight() * density));
        } else {
            this.dst.set(0, 0, (int)((float)bitmap.getWidth() * density), (int)((float)bitmap.getHeight() * density));
        }
        boolean renderOffScreen = shadowToApply != null;
        Canvas targetCanvas = canvas;
        if (renderOffScreen) {
            if (this.offscreenLayer == null) {
                this.offscreenLayer = new OffscreenLayer();
            }
            if (this.offscreenOp == null) {
                this.offscreenOp = new OffscreenLayer.ComposeOp();
            }
            this.offscreenOp.reset();
            shadowToApply.applyWithAlpha(parentAlpha, this.offscreenOp);
            this.layerBounds.set((float)this.dst.left, (float)this.dst.top, (float)this.dst.right, (float)this.dst.bottom);
            parentMatrix.mapRect(this.layerBounds);
            targetCanvas = this.offscreenLayer.start(canvas, this.layerBounds, this.offscreenOp);
        }
        targetCanvas.save();
        targetCanvas.concat(parentMatrix);
        targetCanvas.drawBitmap(bitmap, this.src, this.dst, this.paint);
        if (renderOffScreen) {
            this.offscreenLayer.finish();
        }
        targetCanvas.restore();
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        super.getBounds(outBounds, parentMatrix, applyParents);
        if (this.lottieImageAsset != null) {
            float scale = Utils.dpScale();
            if (this.lottieDrawable.getMaintainOriginalImageBounds()) {
                outBounds.set(0.0f, 0.0f, (float)this.lottieImageAsset.getWidth() * scale, (float)this.lottieImageAsset.getHeight() * scale);
            } else {
                Bitmap bitmap = this.getBitmap();
                if (bitmap != null) {
                    outBounds.set(0.0f, 0.0f, (float)bitmap.getWidth() * scale, (float)bitmap.getHeight() * scale);
                } else {
                    outBounds.set(0.0f, 0.0f, 0.0f, 0.0f);
                }
            }
            this.boundsMatrix.mapRect(outBounds);
        }
    }

    @Nullable
    private Bitmap getBitmap() {
        Bitmap callbackBitmap;
        if (this.imageAnimation != null && (callbackBitmap = this.imageAnimation.getValue()) != null) {
            return callbackBitmap;
        }
        String refId = this.layerModel.getRefId();
        Bitmap bitmapFromDrawable = this.lottieDrawable.getBitmapForId(refId);
        if (bitmapFromDrawable != null) {
            return bitmapFromDrawable;
        }
        LottieImageAsset asset = this.lottieImageAsset;
        if (asset != null) {
            return asset.getBitmap();
        }
        return null;
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.COLOR_FILTER) {
            this.colorFilterAnimation = callback == null ? null : new ValueCallbackKeyframeAnimation<ColorFilter, T>(callback);
        } else if (property == LottieProperty.IMAGE) {
            this.imageAnimation = callback == null ? null : new ValueCallbackKeyframeAnimation<Bitmap, T>(callback);
        } else if (property == LottieProperty.DROP_SHADOW_COLOR && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setColorCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_OPACITY && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setOpacityCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DIRECTION && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDirectionCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DISTANCE && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDistanceCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_RADIUS && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setRadiusCallback(callback);
        }
    }
}

