/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.airbnb.lottie.AsyncUpdates;
import com.airbnb.lottie.configurations.reducemotion.ReducedMotionOption;
import com.airbnb.lottie.configurations.reducemotion.SystemReducedMotionOption;
import com.airbnb.lottie.network.DefaultLottieNetworkFetcher;
import com.airbnb.lottie.network.LottieNetworkCacheProvider;
import com.airbnb.lottie.network.LottieNetworkFetcher;
import com.airbnb.lottie.network.NetworkCache;
import com.airbnb.lottie.network.NetworkFetcher;
import com.airbnb.lottie.utils.LottieTrace;
import java.io.File;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class L {
    public static boolean DBG = false;
    public static final String TAG = "LOTTIE";
    private static boolean traceEnabled = false;
    private static boolean networkCacheEnabled = true;
    private static boolean disablePathInterpolatorCache = false;
    private static AsyncUpdates defaultAsyncUpdates = AsyncUpdates.AUTOMATIC;
    private static LottieNetworkFetcher fetcher;
    private static LottieNetworkCacheProvider cacheProvider;
    private static volatile NetworkFetcher networkFetcher;
    private static volatile NetworkCache networkCache;
    private static ThreadLocal<LottieTrace> lottieTrace;
    private static ReducedMotionOption reducedMotionOption;

    private L() {
    }

    public static void setTraceEnabled(boolean enabled) {
        if (traceEnabled == enabled) {
            return;
        }
        traceEnabled = enabled;
        if (traceEnabled && lottieTrace == null) {
            lottieTrace = new ThreadLocal();
        }
    }

    public static boolean isTraceEnabled() {
        return traceEnabled;
    }

    public static void setNetworkCacheEnabled(boolean enabled) {
        networkCacheEnabled = enabled;
    }

    public static void beginSection(String section) {
        if (!traceEnabled) {
            return;
        }
        L.getTrace().beginSection(section);
    }

    public static float endSection(String section) {
        if (!traceEnabled) {
            return 0.0f;
        }
        return L.getTrace().endSection(section);
    }

    private static LottieTrace getTrace() {
        LottieTrace trace = lottieTrace.get();
        if (trace == null) {
            trace = new LottieTrace();
            lottieTrace.set(trace);
        }
        return trace;
    }

    public static void setFetcher(LottieNetworkFetcher customFetcher) {
        if (fetcher == null && customFetcher == null || fetcher != null && fetcher.equals(customFetcher)) {
            return;
        }
        fetcher = customFetcher;
        networkFetcher = null;
    }

    public static void setCacheProvider(LottieNetworkCacheProvider customProvider) {
        if (cacheProvider == null && customProvider == null || cacheProvider != null && cacheProvider.equals(customProvider)) {
            return;
        }
        cacheProvider = customProvider;
        networkCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static NetworkFetcher networkFetcher(@NonNull Context context) {
        NetworkFetcher local = networkFetcher;
        if (local != null) return local;
        Class<NetworkFetcher> clazz = NetworkFetcher.class;
        synchronized (NetworkFetcher.class) {
            local = networkFetcher;
            if (local != null) return local;
            networkFetcher = local = new NetworkFetcher(L.networkCache(context), fetcher != null ? fetcher : new DefaultLottieNetworkFetcher());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return local;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static NetworkCache networkCache(@NonNull Context context) {
        if (!networkCacheEnabled) {
            return null;
        }
        Context appContext = context.getApplicationContext();
        NetworkCache local = networkCache;
        if (local != null) return local;
        Class<NetworkCache> clazz = NetworkCache.class;
        synchronized (NetworkCache.class) {
            local = networkCache;
            if (local != null) return local;
            networkCache = local = new NetworkCache(cacheProvider != null ? cacheProvider : () -> new File(appContext.getCacheDir(), "lottie_network_cache"));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return local;
        }
    }

    public static void setDisablePathInterpolatorCache(boolean disablePathInterpolatorCache) {
        L.disablePathInterpolatorCache = disablePathInterpolatorCache;
    }

    public static boolean getDisablePathInterpolatorCache() {
        return disablePathInterpolatorCache;
    }

    public static void setDefaultAsyncUpdates(AsyncUpdates asyncUpdates) {
        defaultAsyncUpdates = asyncUpdates;
    }

    public static AsyncUpdates getDefaultAsyncUpdates() {
        return defaultAsyncUpdates;
    }

    public static void setReducedMotionOption(ReducedMotionOption reducedMotionOption) {
        L.reducedMotionOption = reducedMotionOption;
    }

    public static ReducedMotionOption getReducedMotionOption() {
        return reducedMotionOption;
    }

    static {
        reducedMotionOption = new SystemReducedMotionOption();
    }
}

