/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.model.layer;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import androidx.annotation.FloatRange;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.airbnb.lottie.L;
import com.airbnb.lottie.LottieComposition;
import com.airbnb.lottie.LottieDrawable;
import com.airbnb.lottie.LottieProperty;
import com.airbnb.lottie.animation.keyframe.BaseKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.DropShadowKeyframeAnimation;
import com.airbnb.lottie.animation.keyframe.ValueCallbackKeyframeAnimation;
import com.airbnb.lottie.model.KeyPath;
import com.airbnb.lottie.model.animatable.AnimatableFloatValue;
import com.airbnb.lottie.model.layer.BaseLayer;
import com.airbnb.lottie.model.layer.Layer;
import com.airbnb.lottie.model.layer.ShapeLayer;
import com.airbnb.lottie.utils.DropShadow;
import com.airbnb.lottie.utils.OffscreenLayer;
import com.airbnb.lottie.value.LottieValueCallback;
import java.util.ArrayList;
import java.util.List;

public class CompositionLayer
extends BaseLayer {
    @Nullable
    private BaseKeyframeAnimation<Float, Float> timeRemapping;
    private final List<BaseLayer> layers = new ArrayList<BaseLayer>();
    private final RectF rect = new RectF();
    private final RectF newClipRect = new RectF();
    private final RectF layerBounds = new RectF();
    private final OffscreenLayer offscreenLayer = new OffscreenLayer();
    private final OffscreenLayer.ComposeOp offscreenOp = new OffscreenLayer.ComposeOp();
    @Nullable
    private Boolean hasMatte;
    @Nullable
    private Boolean hasMasks;
    private float progress;
    private boolean clipToCompositionBounds = true;
    @Nullable
    private DropShadowKeyframeAnimation dropShadowAnimation;

    public CompositionLayer(LottieDrawable lottieDrawable, Layer layerModel, List<Layer> layerModels, LottieComposition composition) {
        super(lottieDrawable, layerModel);
        int i;
        AnimatableFloatValue timeRemapping = layerModel.getTimeRemapping();
        if (timeRemapping != null) {
            this.timeRemapping = timeRemapping.createAnimation();
            this.addAnimation(this.timeRemapping);
            this.timeRemapping.addUpdateListener(this);
        } else {
            this.timeRemapping = null;
        }
        LongSparseArray layerMap = new LongSparseArray(composition.getLayers().size());
        BaseLayer mattedLayer = null;
        for (i = layerModels.size() - 1; i >= 0; --i) {
            Layer lm = layerModels.get(i);
            BaseLayer layer = BaseLayer.forModel(this, lm, lottieDrawable, composition);
            if (layer == null) continue;
            layerMap.put(layer.getLayerModel().getId(), (Object)layer);
            if (mattedLayer != null) {
                mattedLayer.setMatteLayer(layer);
                mattedLayer = null;
                continue;
            }
            this.layers.add(0, layer);
            switch (lm.getMatteType()) {
                case ADD: 
                case INVERT: {
                    mattedLayer = layer;
                }
            }
        }
        for (i = 0; i < layerMap.size(); ++i) {
            BaseLayer parentLayer;
            long key = layerMap.keyAt(i);
            BaseLayer layerView = (BaseLayer)layerMap.get(key);
            if (layerView == null || (parentLayer = (BaseLayer)layerMap.get(layerView.getLayerModel().getParentId())) == null) continue;
            layerView.setParentLayer(parentLayer);
        }
        if (this.getDropShadowEffect() != null) {
            this.dropShadowAnimation = new DropShadowKeyframeAnimation(this, this, this.getDropShadowEffect());
        }
    }

    public void setClipToCompositionBounds(boolean clipToCompositionBounds) {
        this.clipToCompositionBounds = clipToCompositionBounds;
    }

    @Override
    public void setOutlineMasksAndMattes(boolean outline) {
        super.setOutlineMasksAndMattes(outline);
        for (BaseLayer layer : this.layers) {
            layer.setOutlineMasksAndMattes(outline);
        }
    }

    @Override
    void drawLayer(Canvas canvas, Matrix parentMatrix, int parentAlpha, @Nullable DropShadow parentShadowToApply) {
        boolean ignoreClipOnThisLayer;
        if (L.isTraceEnabled()) {
            L.beginSection("CompositionLayer#draw");
        }
        boolean hasShadow = parentShadowToApply != null || this.dropShadowAnimation != null;
        boolean isDrawingWithOffScreen = this.lottieDrawable.isApplyingOpacityToLayersEnabled() && this.layers.size() > 1 && parentAlpha != 255 || hasShadow && this.lottieDrawable.isApplyingShadowToLayersEnabled();
        int childAlpha = isDrawingWithOffScreen ? 255 : parentAlpha;
        DropShadow shadowToApply = this.dropShadowAnimation != null ? this.dropShadowAnimation.evaluate(parentMatrix, childAlpha) : parentShadowToApply;
        boolean bl = ignoreClipOnThisLayer = !this.clipToCompositionBounds && "__container".equals(this.layerModel.getName());
        if (!ignoreClipOnThisLayer) {
            this.newClipRect.set(0.0f, 0.0f, this.layerModel.getPreCompWidth(), this.layerModel.getPreCompHeight());
            parentMatrix.mapRect(this.newClipRect);
        } else {
            this.newClipRect.setEmpty();
            for (BaseLayer layer : this.layers) {
                layer.getBounds(this.layerBounds, parentMatrix, true);
                this.newClipRect.union(this.layerBounds);
            }
        }
        Canvas targetCanvas = canvas;
        if (isDrawingWithOffScreen) {
            this.offscreenOp.reset();
            this.offscreenOp.alpha = parentAlpha;
            if (shadowToApply != null) {
                shadowToApply.applyTo(this.offscreenOp);
                shadowToApply = null;
            }
            targetCanvas = this.offscreenLayer.start(canvas, this.newClipRect, this.offscreenOp);
        }
        canvas.save();
        if (canvas.clipRect(this.newClipRect)) {
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                BaseLayer layer = this.layers.get(i);
                layer.draw(targetCanvas, parentMatrix, childAlpha, shadowToApply);
            }
        }
        if (isDrawingWithOffScreen) {
            this.offscreenLayer.finish();
        }
        canvas.restore();
        if (L.isTraceEnabled()) {
            L.endSection("CompositionLayer#draw");
        }
    }

    @Override
    public void getBounds(RectF outBounds, Matrix parentMatrix, boolean applyParents) {
        super.getBounds(outBounds, parentMatrix, applyParents);
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.rect.set(0.0f, 0.0f, 0.0f, 0.0f);
            this.layers.get(i).getBounds(this.rect, this.boundsMatrix, true);
            outBounds.union(this.rect);
        }
    }

    @Override
    public void setProgress(@FloatRange(from=0.0, to=1.0) float progress) {
        if (L.isTraceEnabled()) {
            L.beginSection("CompositionLayer#setProgress");
        }
        this.progress = progress;
        super.setProgress(progress);
        if (this.timeRemapping != null) {
            float durationFrames = this.lottieDrawable.getComposition().getDurationFrames() + 0.01f;
            float compositionDelayFrames = this.layerModel.getComposition().getStartFrame();
            float remappedFrames = this.timeRemapping.getValue().floatValue() * this.layerModel.getComposition().getFrameRate() - compositionDelayFrames;
            progress = remappedFrames / durationFrames;
        }
        if (this.timeRemapping == null) {
            progress -= this.layerModel.getStartProgress();
        }
        if (this.layerModel.getTimeStretch() != 0.0f && !"__container".equals(this.layerModel.getName())) {
            progress /= this.layerModel.getTimeStretch();
        }
        for (int i = this.layers.size() - 1; i >= 0; --i) {
            this.layers.get(i).setProgress(progress);
        }
        if (L.isTraceEnabled()) {
            L.endSection("CompositionLayer#setProgress");
        }
    }

    public float getProgress() {
        return this.progress;
    }

    public boolean hasMasks() {
        if (this.hasMasks == null) {
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                BaseLayer layer = this.layers.get(i);
                if (layer instanceof ShapeLayer) {
                    if (!layer.hasMasksOnThisLayer()) continue;
                    this.hasMasks = true;
                    return true;
                }
                if (!(layer instanceof CompositionLayer) || !((CompositionLayer)layer).hasMasks()) continue;
                this.hasMasks = true;
                return true;
            }
            this.hasMasks = false;
        }
        return this.hasMasks;
    }

    public boolean hasMatte() {
        if (this.hasMatte == null) {
            if (this.hasMatteOnThisLayer()) {
                this.hasMatte = true;
                return true;
            }
            for (int i = this.layers.size() - 1; i >= 0; --i) {
                if (!this.layers.get(i).hasMatteOnThisLayer()) continue;
                this.hasMatte = true;
                return true;
            }
            this.hasMatte = false;
        }
        return this.hasMatte;
    }

    @Override
    protected void resolveChildKeyPath(KeyPath keyPath, int depth, List<KeyPath> accumulator, KeyPath currentPartialKeyPath) {
        for (int i = 0; i < this.layers.size(); ++i) {
            this.layers.get(i).resolveKeyPath(keyPath, depth, accumulator, currentPartialKeyPath);
        }
    }

    @Override
    public <T> void addValueCallback(T property, @Nullable LottieValueCallback<T> callback) {
        super.addValueCallback(property, callback);
        if (property == LottieProperty.TIME_REMAP) {
            if (callback == null) {
                if (this.timeRemapping != null) {
                    this.timeRemapping.setValueCallback(null);
                }
            } else {
                this.timeRemapping = new ValueCallbackKeyframeAnimation<Float, T>(callback);
                this.timeRemapping.addUpdateListener(this);
                this.addAnimation(this.timeRemapping);
            }
        } else if (property == LottieProperty.DROP_SHADOW_COLOR && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setColorCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_OPACITY && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setOpacityCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DIRECTION && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDirectionCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_DISTANCE && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setDistanceCallback(callback);
        } else if (property == LottieProperty.DROP_SHADOW_RADIUS && this.dropShadowAnimation != null) {
            this.dropShadowAnimation.setRadiusCallback(callback);
        }
    }
}

