/*
 * Decompiled with CFR 0.152.
 */
package com.airbnb.lottie.utils;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.os.Build;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class BaseLottieAnimator
extends ValueAnimator {
    private final Set<ValueAnimator.AnimatorUpdateListener> updateListeners = new CopyOnWriteArraySet<ValueAnimator.AnimatorUpdateListener>();
    private final Set<Animator.AnimatorListener> listeners = new CopyOnWriteArraySet<Animator.AnimatorListener>();
    private final Set<Animator.AnimatorPauseListener> pauseListeners = new CopyOnWriteArraySet<Animator.AnimatorPauseListener>();

    public long getStartDelay() {
        throw new UnsupportedOperationException("LottieAnimator does not support getStartDelay.");
    }

    public void setStartDelay(long startDelay) {
        throw new UnsupportedOperationException("LottieAnimator does not support setStartDelay.");
    }

    public ValueAnimator setDuration(long duration) {
        throw new UnsupportedOperationException("LottieAnimator does not support setDuration.");
    }

    public void setInterpolator(TimeInterpolator value) {
        throw new UnsupportedOperationException("LottieAnimator does not support setInterpolator.");
    }

    public void addUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.updateListeners.add(listener);
    }

    public void removeUpdateListener(ValueAnimator.AnimatorUpdateListener listener) {
        this.updateListeners.remove(listener);
    }

    public void removeAllUpdateListeners() {
        this.updateListeners.clear();
    }

    public void addListener(Animator.AnimatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Animator.AnimatorListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllListeners() {
        this.listeners.clear();
    }

    void notifyStart(boolean isReverse) {
        for (Animator.AnimatorListener listener : this.listeners) {
            if (Build.VERSION.SDK_INT >= 26) {
                listener.onAnimationStart((Animator)this, isReverse);
                continue;
            }
            listener.onAnimationStart((Animator)this);
        }
    }

    public void addPauseListener(Animator.AnimatorPauseListener listener) {
        this.pauseListeners.add(listener);
    }

    public void removePauseListener(Animator.AnimatorPauseListener listener) {
        this.pauseListeners.remove(listener);
    }

    void notifyRepeat() {
        for (Animator.AnimatorListener listener : this.listeners) {
            listener.onAnimationRepeat((Animator)this);
        }
    }

    void notifyEnd(boolean isReverse) {
        for (Animator.AnimatorListener listener : this.listeners) {
            if (Build.VERSION.SDK_INT >= 26) {
                listener.onAnimationEnd((Animator)this, isReverse);
                continue;
            }
            listener.onAnimationEnd((Animator)this);
        }
    }

    void notifyCancel() {
        for (Animator.AnimatorListener listener : this.listeners) {
            listener.onAnimationCancel((Animator)this);
        }
    }

    void notifyUpdate() {
        for (ValueAnimator.AnimatorUpdateListener listener : this.updateListeners) {
            listener.onAnimationUpdate((ValueAnimator)this);
        }
    }

    void notifyPause() {
        if (Build.VERSION.SDK_INT >= 19) {
            for (Animator.AnimatorPauseListener pauseListener : this.pauseListeners) {
                pauseListener.onAnimationPause((Animator)this);
            }
        }
    }

    void notifyResume() {
        if (Build.VERSION.SDK_INT >= 19) {
            for (Animator.AnimatorPauseListener pauseListener : this.pauseListeners) {
                pauseListener.onAnimationResume((Animator)this);
            }
        }
    }
}

