/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * DestinationRedshiftUploadingMethodS3Staging - The method how the data will be uploaded to the database.
 */

public class DestinationRedshiftUploadingMethodS3Staging {
    /**
     * This ID grants access to the above S3 staging bucket. Airbyte requires Read and Write permissions to the given bucket. See &lt;a href="https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys"&gt;AWS docs&lt;/a&gt; on how to generate an access key ID and secret access key.
     */
    @JsonProperty("access_key_id")
    public String accessKeyId;

    public DestinationRedshiftUploadingMethodS3Staging withAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }
    
    /**
     * How to encrypt the staging data
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("encryption")
    public Object encryption;

    public DestinationRedshiftUploadingMethodS3Staging withEncryption(Object encryption) {
        this.encryption = encryption;
        return this;
    }
    
    /**
     * Number of file buffers allocated for writing data. Increasing this number is beneficial for connections using Change Data Capture (CDC) and up to the number of streams within a connection. Increasing the number of file buffers past the maximum number of streams has deteriorating effects
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_buffer_count")
    public Long fileBufferCount;

    public DestinationRedshiftUploadingMethodS3Staging withFileBufferCount(Long fileBufferCount) {
        this.fileBufferCount = fileBufferCount;
        return this;
    }
    
    /**
     * The pattern allows you to set the file-name format for the S3 staging file(s)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_name_pattern")
    public String fileNamePattern;

    public DestinationRedshiftUploadingMethodS3Staging withFileNamePattern(String fileNamePattern) {
        this.fileNamePattern = fileNamePattern;
        return this;
    }
    
    @JsonProperty("method")
    public DestinationRedshiftUploadingMethodS3StagingMethod method;

    public DestinationRedshiftUploadingMethodS3Staging withMethod(DestinationRedshiftUploadingMethodS3StagingMethod method) {
        this.method = method;
        return this;
    }
    
    /**
     * Whether to delete the staging files from S3 after completing the sync. See &lt;a href="https://docs.airbyte.com/integrations/destinations/redshift/#:~:text=the%20root%20directory.-,Purge%20Staging%20Data,-Whether%20to%20delete"&gt; docs&lt;/a&gt; for details.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("purge_staging_data")
    public Boolean purgeStagingData;

    public DestinationRedshiftUploadingMethodS3Staging withPurgeStagingData(Boolean purgeStagingData) {
        this.purgeStagingData = purgeStagingData;
        return this;
    }
    
    /**
     * The name of the staging S3 bucket to use if utilising a COPY strategy. COPY is recommended for production workloads for better speed and scalability. See &lt;a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-bucket.html"&gt;AWS docs&lt;/a&gt; for more details.
     */
    @JsonProperty("s3_bucket_name")
    public String s3BucketName;

    public DestinationRedshiftUploadingMethodS3Staging withS3BucketName(String s3BucketName) {
        this.s3BucketName = s3BucketName;
        return this;
    }
    
    /**
     * The directory under the S3 bucket where data will be written. If not provided, then defaults to the root directory. See &lt;a href="https://docs.aws.amazon.com/prescriptive-guidance/latest/defining-bucket-names-data-lakes/faq.html#:~:text=be%20globally%20unique.-,For%20S3%20bucket%20paths,-%2C%20you%20can%20use"&gt;path's name recommendations&lt;/a&gt; for more details.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("s3_bucket_path")
    public String s3BucketPath;

    public DestinationRedshiftUploadingMethodS3Staging withS3BucketPath(String s3BucketPath) {
        this.s3BucketPath = s3BucketPath;
        return this;
    }
    
    /**
     * The region of the S3 staging bucket to use if utilising a COPY strategy. See &lt;a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/creating-bucket.html#:~:text=In-,Region,-%2C%20choose%20the%20AWS"&gt;AWS docs&lt;/a&gt; for details.
     */
    @JsonProperty("s3_bucket_region")
    public DestinationRedshiftUploadingMethodS3StagingS3BucketRegion s3BucketRegion;

    public DestinationRedshiftUploadingMethodS3Staging withS3BucketRegion(DestinationRedshiftUploadingMethodS3StagingS3BucketRegion s3BucketRegion) {
        this.s3BucketRegion = s3BucketRegion;
        return this;
    }
    
    /**
     * The corresponding secret to the above access key id. See &lt;a href="https://docs.aws.amazon.com/general/latest/gr/aws-sec-cred-types.html#access-keys-and-secret-access-keys"&gt;AWS docs&lt;/a&gt; on how to generate an access key ID and secret access key.
     */
    @JsonProperty("secret_access_key")
    public String secretAccessKey;

    public DestinationRedshiftUploadingMethodS3Staging withSecretAccessKey(String secretAccessKey) {
        this.secretAccessKey = secretAccessKey;
        return this;
    }
    
    public DestinationRedshiftUploadingMethodS3Staging(@JsonProperty("access_key_id") String accessKeyId, @JsonProperty("method") DestinationRedshiftUploadingMethodS3StagingMethod method, @JsonProperty("s3_bucket_name") String s3BucketName, @JsonProperty("s3_bucket_region") DestinationRedshiftUploadingMethodS3StagingS3BucketRegion s3BucketRegion, @JsonProperty("secret_access_key") String secretAccessKey) {
        this.accessKeyId = accessKeyId;
        this.method = method;
        this.s3BucketName = s3BucketName;
        this.s3BucketRegion = s3BucketRegion;
        this.secretAccessKey = secretAccessKey;
  }
}
