/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SourceAmplitude - The values required to configure the source.
 */

public class SourceAmplitude {
    /**
     * Amplitude API Key. See the &lt;a href="https://docs.airbyte.com/integrations/sources/amplitude#setup-guide"&gt;setup guide&lt;/a&gt; for more information on how to obtain this key.
     */
    @JsonProperty("api_key")
    public String apiKey;

    public SourceAmplitude withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }
    
    /**
     * Amplitude data region server
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("data_region")
    public SourceAmplitudeDataRegion dataRegion;

    public SourceAmplitude withDataRegion(SourceAmplitudeDataRegion dataRegion) {
        this.dataRegion = dataRegion;
        return this;
    }
    
    /**
     * According to &lt;a href="https://www.docs.developers.amplitude.com/analytics/apis/export-api/#considerations"&gt;Considerations&lt;/a&gt; too big time range in request can cause a timeout error. In this case, set shorter time interval in hours.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("request_time_range")
    public Long requestTimeRange;

    public SourceAmplitude withRequestTimeRange(Long requestTimeRange) {
        this.requestTimeRange = requestTimeRange;
        return this;
    }
    
    /**
     * Amplitude Secret Key. See the &lt;a href="https://docs.airbyte.com/integrations/sources/amplitude#setup-guide"&gt;setup guide&lt;/a&gt; for more information on how to obtain this key.
     */
    @JsonProperty("secret_key")
    public String secretKey;

    public SourceAmplitude withSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceAmplitudeAmplitude sourceType;

    public SourceAmplitude withSourceType(SourceAmplitudeAmplitude sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * UTC date and time in the format 2021-01-25T00:00:00Z. Any data before this date will not be replicated.
     */
    @JsonProperty("start_date")
    public String startDate;

    public SourceAmplitude withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourceAmplitude(@JsonProperty("api_key") String apiKey, @JsonProperty("secret_key") String secretKey, @JsonProperty("sourceType") SourceAmplitudeAmplitude sourceType, @JsonProperty("start_date") String startDate) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
        this.sourceType = sourceType;
        this.startDate = startDate;
  }
}
