/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceChartmogul - The values required to configure the source.
 */

public class SourceChartmogul {
    /**
     * Your Chartmogul API key. See &lt;a href="https://help.chartmogul.com/hc/en-us/articles/4407796325906-Creating-and-Managing-API-keys#creating-an-api-key"&gt; the docs &lt;/a&gt; for info on how to obtain this.
     */
    @JsonProperty("api_key")
    public String apiKey;

    public SourceChartmogul withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }
    
    /**
     * Some APIs such as &lt;a href="https://dev.chartmogul.com/reference/endpoint-overview-metrics-api"&gt;Metrics&lt;/a&gt; require intervals to cluster data.
     */
    @JsonProperty("interval")
    public SourceChartmogulInterval interval;

    public SourceChartmogul withInterval(SourceChartmogulInterval interval) {
        this.interval = interval;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceChartmogulChartmogul sourceType;

    public SourceChartmogul withSourceType(SourceChartmogulChartmogul sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * UTC date and time in the format 2017-01-25T00:00:00Z. When feasible, any data before this date will not be replicated.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceChartmogul withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourceChartmogul(@JsonProperty("api_key") String apiKey, @JsonProperty("interval") SourceChartmogulInterval interval, @JsonProperty("sourceType") SourceChartmogulChartmogul sourceType, @JsonProperty("start_date") OffsetDateTime startDate) {
        this.apiKey = apiKey;
        this.interval = interval;
        this.sourceType = sourceType;
        this.startDate = startDate;
  }
}
