/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * SourceGnews - The values required to configure the source.
 */

public class SourceGnews {
    /**
     * API Key
     */
    @JsonProperty("api_key")
    public String apiKey;

    public SourceGnews withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }
    
    /**
     * This parameter allows you to specify the country where the news articles returned by the API were published, the contents of the articles are not necessarily related to the specified country. You have to set as value the 2 letters code of the country you want to filter.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("country")
    public SourceGnewsCountry country;

    public SourceGnews withCountry(SourceGnewsCountry country) {
        this.country = country;
        return this;
    }
    
    /**
     * This parameter allows you to filter the articles that have a publication date smaller than or equal to the  specified value. The date must respect the following format: YYYY-MM-DD hh:mm:ss (in UTC)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("end_date")
    public String endDate;

    public SourceGnews withEndDate(String endDate) {
        this.endDate = endDate;
        return this;
    }
    
    /**
     * This parameter allows you to choose in which attributes the keywords are searched. The attributes that can be set are title, description and content. It is possible to combine several attributes.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("in")
    public SourceGnewsIn[] in;

    public SourceGnews withIn(SourceGnewsIn[] in) {
        this.in = in;
        return this;
    }
    
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("language")
    public SourceGnewsLanguage language;

    public SourceGnews withLanguage(SourceGnewsLanguage language) {
        this.language = language;
        return this;
    }
    
    /**
     * This parameter allows you to specify the attributes that you allow to return null values. The attributes that  can be set are title, description and content. It is possible to combine several attributes
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("nullable")
    public SourceGnewsNullable[] nullable;

    public SourceGnews withNullable(SourceGnewsNullable[] nullable) {
        this.nullable = nullable;
        return this;
    }
    
    /**
     * This parameter allows you to specify your search keywords to find the news articles you are looking for. The keywords will be used to return the most relevant articles. It is possible to use logical operators  with keywords. - Phrase Search Operator: This operator allows you to make an exact search. Keywords surrounded by 
     *   quotation marks are used to search for articles with the exact same keyword sequence. 
     *   For example the query: "Apple iPhone" will return articles matching at least once this sequence of keywords.
     * - Logical AND Operator: This operator allows you to make sure that several keywords are all used in the article
     *   search. By default the space character acts as an AND operator, it is possible to replace the space character 
     *   by AND to obtain the same result. For example the query: Apple Microsoft is equivalent to Apple AND Microsoft
     * - Logical OR Operator: This operator allows you to retrieve articles matching the keyword a or the keyword b.
     *   It is important to note that this operator has a higher precedence than the AND operator. For example the 
     *   query: Apple OR Microsoft will return all articles matching the keyword Apple as well as all articles matching 
     *   the keyword Microsoft
     * - Logical NOT Operator: This operator allows you to remove from the results the articles corresponding to the
     *   specified keywords. To use it, you need to add NOT in front of each word or phrase surrounded by quotes.
     *   For example the query: Apple NOT iPhone will return all articles matching the keyword Apple but not the keyword
     *   iPhone
     */
    @JsonProperty("query")
    public String query;

    public SourceGnews withQuery(String query) {
        this.query = query;
        return this;
    }
    
    /**
     * This parameter allows you to choose with which type of sorting the articles should be returned. Two values  are possible:
     *   - publishedAt = sort by publication date, the articles with the most recent publication date are returned first
     *   - relevance = sort by best match to keywords, the articles with the best match are returned first
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sortby")
    public SourceGnewsSortBy sortby;

    public SourceGnews withSortby(SourceGnewsSortBy sortby) {
        this.sortby = sortby;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceGnewsGnews sourceType;

    public SourceGnews withSourceType(SourceGnewsGnews sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * This parameter allows you to filter the articles that have a publication date greater than or equal to the  specified value. The date must respect the following format: YYYY-MM-DD hh:mm:ss (in UTC)
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("start_date")
    public String startDate;

    public SourceGnews withStartDate(String startDate) {
        this.startDate = startDate;
        return this;
    }
    
    /**
     * This parameter allows you to specify your search keywords to find the news articles you are looking for. The keywords will be used to return the most relevant articles. It is possible to use logical operators  with keywords. - Phrase Search Operator: This operator allows you to make an exact search. Keywords surrounded by 
     *   quotation marks are used to search for articles with the exact same keyword sequence. 
     *   For example the query: "Apple iPhone" will return articles matching at least once this sequence of keywords.
     * - Logical AND Operator: This operator allows you to make sure that several keywords are all used in the article
     *   search. By default the space character acts as an AND operator, it is possible to replace the space character 
     *   by AND to obtain the same result. For example the query: Apple Microsoft is equivalent to Apple AND Microsoft
     * - Logical OR Operator: This operator allows you to retrieve articles matching the keyword a or the keyword b.
     *   It is important to note that this operator has a higher precedence than the AND operator. For example the 
     *   query: Apple OR Microsoft will return all articles matching the keyword Apple as well as all articles matching 
     *   the keyword Microsoft
     * - Logical NOT Operator: This operator allows you to remove from the results the articles corresponding to the
     *   specified keywords. To use it, you need to add NOT in front of each word or phrase surrounded by quotes.
     *   For example the query: Apple NOT iPhone will return all articles matching the keyword Apple but not the keyword
     *   iPhone
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("top_headlines_query")
    public String topHeadlinesQuery;

    public SourceGnews withTopHeadlinesQuery(String topHeadlinesQuery) {
        this.topHeadlinesQuery = topHeadlinesQuery;
        return this;
    }
    
    /**
     * This parameter allows you to change the category for the request.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("top_headlines_topic")
    public SourceGnewsTopHeadlinesTopic topHeadlinesTopic;

    public SourceGnews withTopHeadlinesTopic(SourceGnewsTopHeadlinesTopic topHeadlinesTopic) {
        this.topHeadlinesTopic = topHeadlinesTopic;
        return this;
    }
    
    public SourceGnews(@JsonProperty("api_key") String apiKey, @JsonProperty("query") String query, @JsonProperty("sourceType") SourceGnewsGnews sourceType) {
        this.apiKey = apiKey;
        this.query = query;
        this.sourceType = sourceType;
  }
}
