/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceJira - The values required to configure the source.
 */

public class SourceJira {
    /**
     * Jira API Token. See the &lt;a href="https://docs.airbyte.com/integrations/sources/jira"&gt;docs&lt;/a&gt; for more information on how to generate this key. API Token is used for Authorization to your account by BasicAuth.
     */
    @JsonProperty("api_token")
    public String apiToken;

    public SourceJira withApiToken(String apiToken) {
        this.apiToken = apiToken;
        return this;
    }
    
    /**
     * The Domain for your Jira account, e.g. airbyteio.atlassian.net, airbyteio.jira.com, jira.your-domain.com
     */
    @JsonProperty("domain")
    public String domain;

    public SourceJira withDomain(String domain) {
        this.domain = domain;
        return this;
    }
    
    /**
     * The user email for your Jira account which you used to generate the API token. This field is used for Authorization to your account by BasicAuth.
     */
    @JsonProperty("email")
    public String email;

    public SourceJira withEmail(String email) {
        this.email = email;
        return this;
    }
    
    /**
     * Allow the use of experimental streams which rely on undocumented Jira API endpoints. See https://docs.airbyte.com/integrations/sources/jira#experimental-tables for more info.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("enable_experimental_streams")
    public Boolean enableExperimentalStreams;

    public SourceJira withEnableExperimentalStreams(Boolean enableExperimentalStreams) {
        this.enableExperimentalStreams = enableExperimentalStreams;
        return this;
    }
    
    /**
     * Expand the changelog when replicating issues.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("expand_issue_changelog")
    public Boolean expandIssueChangelog;

    public SourceJira withExpandIssueChangelog(Boolean expandIssueChangelog) {
        this.expandIssueChangelog = expandIssueChangelog;
        return this;
    }
    
    /**
     * List of Jira project keys to replicate data for, or leave it empty if you want to replicate data for all projects.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("projects")
    public String[] projects;

    public SourceJira withProjects(String[] projects) {
        this.projects = projects;
        return this;
    }
    
    /**
     * Render issue fields in HTML format in addition to Jira JSON-like format.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("render_fields")
    public Boolean renderFields;

    public SourceJira withRenderFields(Boolean renderFields) {
        this.renderFields = renderFields;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceJiraJira sourceType;

    public SourceJira withSourceType(SourceJiraJira sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * The date from which you want to replicate data from Jira, use the format YYYY-MM-DDT00:00:00Z. Note that this field only applies to certain streams, and only data generated on or after the start date will be replicated. Or leave it empty if you want to replicate all data. For more information, refer to the &lt;a href="https://docs.airbyte.com/integrations/sources/jira/"&gt;documentation&lt;/a&gt;.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceJira withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourceJira(@JsonProperty("api_token") String apiToken, @JsonProperty("domain") String domain, @JsonProperty("email") String email, @JsonProperty("sourceType") SourceJiraJira sourceType) {
        this.apiToken = apiToken;
        this.domain = domain;
        this.email = email;
        this.sourceType = sourceType;
  }
}
