/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceMixpanel - The values required to configure the source.
 */

public class SourceMixpanel {
    /**
     *  A period of time for attributing results to ads and the lookback period after those actions occur during which ad results are counted. Default attribution window is 5 days.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("attribution_window")
    public Long attributionWindow;

    public SourceMixpanel withAttributionWindow(Long attributionWindow) {
        this.attributionWindow = attributionWindow;
        return this;
    }
    
    /**
     * Choose how to authenticate to Mixpanel
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("credentials")
    public Object credentials;

    public SourceMixpanel withCredentials(Object credentials) {
        this.credentials = credentials;
        return this;
    }
    
    /**
     * Defines window size in days, that used to slice through data. You can reduce it, if amount of data in each window is too big for your environment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("date_window_size")
    public Long dateWindowSize;

    public SourceMixpanel withDateWindowSize(Long dateWindowSize) {
        this.dateWindowSize = dateWindowSize;
        return this;
    }
    
    /**
     * The date in the format YYYY-MM-DD. Any data after this date will not be replicated. Left empty to always sync to most recent date
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("end_date")
    public OffsetDateTime endDate;

    public SourceMixpanel withEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }
    
    /**
     * Your project ID number. See the &lt;a href="https://help.mixpanel.com/hc/en-us/articles/115004490503-Project-Settings#project-id"&gt;docs&lt;/a&gt; for more information on how to obtain this.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("project_id")
    public Long projectId;

    public SourceMixpanel withProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }
    
    /**
     * Time zone in which integer date times are stored. The project timezone may be found in the project settings in the &lt;a href="https://help.mixpanel.com/hc/en-us/articles/115004547203-Manage-Timezones-for-Projects-in-Mixpanel"&gt;Mixpanel console&lt;/a&gt;.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("project_timezone")
    public String projectTimezone;

    public SourceMixpanel withProjectTimezone(String projectTimezone) {
        this.projectTimezone = projectTimezone;
        return this;
    }
    
    /**
     * The region of mixpanel domain instance either US or EU.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("region")
    public SourceMixpanelRegion region;

    public SourceMixpanel withRegion(SourceMixpanelRegion region) {
        this.region = region;
        return this;
    }
    
    /**
     * Setting this config parameter to TRUE ensures that new properties on events and engage records are captured. Otherwise new properties will be ignored.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("select_properties_by_default")
    public Boolean selectPropertiesByDefault;

    public SourceMixpanel withSelectPropertiesByDefault(Boolean selectPropertiesByDefault) {
        this.selectPropertiesByDefault = selectPropertiesByDefault;
        return this;
    }
    
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("sourceType")
    public SourceMixpanelMixpanel sourceType;

    public SourceMixpanel withSourceType(SourceMixpanelMixpanel sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * The date in the format YYYY-MM-DD. Any data before this date will not be replicated. If this option is not set, the connector will replicate data from up to one year ago by default.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceMixpanel withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourceMixpanel(){}
}
