/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceOnesignal - The values required to configure the source.
 */

public class SourceOnesignal {
    /**
     * Applications keys, see the &lt;a href="https://documentation.onesignal.com/docs/accounts-and-keys"&gt;docs&lt;/a&gt; for more information on how to obtain this data
     */
    @JsonProperty("applications")
    public SourceOnesignalApplications[] applications;

    public SourceOnesignal withApplications(SourceOnesignalApplications[] applications) {
        this.applications = applications;
        return this;
    }
    
    /**
     * Comma-separated list of names and the value (sum/count) for the returned outcome data. See the &lt;a href="https://documentation.onesignal.com/reference/view-outcomes"&gt;docs&lt;/a&gt; for more details
     */
    @JsonProperty("outcome_names")
    public String outcomeNames;

    public SourceOnesignal withOutcomeNames(String outcomeNames) {
        this.outcomeNames = outcomeNames;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceOnesignalOnesignal sourceType;

    public SourceOnesignal withSourceType(SourceOnesignalOnesignal sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * The date from which you'd like to replicate data for OneSignal API, in the format YYYY-MM-DDT00:00:00Z. All data generated after this date will be replicated.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceOnesignal withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    /**
     * OneSignal User Auth Key, see the &lt;a href="https://documentation.onesignal.com/docs/accounts-and-keys#user-auth-key"&gt;docs&lt;/a&gt; for more information on how to obtain this key.
     */
    @JsonProperty("user_auth_key")
    public String userAuthKey;

    public SourceOnesignal withUserAuthKey(String userAuthKey) {
        this.userAuthKey = userAuthKey;
        return this;
    }
    
    public SourceOnesignal(@JsonProperty("applications") SourceOnesignalApplications[] applications, @JsonProperty("outcome_names") String outcomeNames, @JsonProperty("sourceType") SourceOnesignalOnesignal sourceType, @JsonProperty("start_date") OffsetDateTime startDate, @JsonProperty("user_auth_key") String userAuthKey) {
        this.applications = applications;
        this.outcomeNames = outcomeNames;
        this.sourceType = sourceType;
        this.startDate = startDate;
        this.userAuthKey = userAuthKey;
  }
}
