/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourcePaypalTransaction - The values required to configure the source.
 */

public class SourcePaypalTransaction {
    /**
     * The Client ID of your Paypal developer application.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("client_id")
    public String clientId;

    public SourcePaypalTransaction withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }
    
    /**
     * The Client Secret of your Paypal developer application.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("client_secret")
    public String clientSecret;

    public SourcePaypalTransaction withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }
    
    /**
     * Determines whether to use the sandbox or production environment.
     */
    @JsonProperty("is_sandbox")
    public Boolean isSandbox;

    public SourcePaypalTransaction withIsSandbox(Boolean isSandbox) {
        this.isSandbox = isSandbox;
        return this;
    }
    
    /**
     * The key to refresh the expired access token.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("refresh_token")
    public String refreshToken;

    public SourcePaypalTransaction withRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourcePaypalTransactionPaypalTransaction sourceType;

    public SourcePaypalTransaction withSourceType(SourcePaypalTransactionPaypalTransaction sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * Start Date for data extraction in &lt;a href="https://datatracker.ietf.org/doc/html/rfc3339#section-5.6"&gt;ISO format&lt;/a&gt;. Date must be in range from 3 years till 12 hrs before present time.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourcePaypalTransaction withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourcePaypalTransaction(@JsonProperty("is_sandbox") Boolean isSandbox, @JsonProperty("sourceType") SourcePaypalTransactionPaypalTransaction sourceType, @JsonProperty("start_date") OffsetDateTime startDate) {
        this.isSandbox = isSandbox;
        this.sourceType = sourceType;
        this.startDate = startDate;
  }
}
