/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourcePosthog - The values required to configure the source.
 */

public class SourcePosthog {
    /**
     * API Key. See the &lt;a href="https://docs.airbyte.com/integrations/sources/posthog"&gt;docs&lt;/a&gt; for information on how to generate this key.
     */
    @JsonProperty("api_key")
    public String apiKey;

    public SourcePosthog withApiKey(String apiKey) {
        this.apiKey = apiKey;
        return this;
    }
    
    /**
     * Base PostHog url. Defaults to PostHog Cloud (https://app.posthog.com).
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("base_url")
    public String baseUrl;

    public SourcePosthog withBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourcePosthogPosthog sourceType;

    public SourcePosthog withSourceType(SourcePosthogPosthog sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * The date from which you'd like to replicate the data. Any data before this date will not be replicated.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourcePosthog withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourcePosthog(@JsonProperty("api_key") String apiKey, @JsonProperty("sourceType") SourcePosthogPosthog sourceType, @JsonProperty("start_date") OffsetDateTime startDate) {
        this.apiKey = apiKey;
        this.sourceType = sourceType;
        this.startDate = startDate;
  }
}
