/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceS3S3AmazonWebServices - Use this to load files from S3 or S3-compatible services
 */

public class SourceS3S3AmazonWebServices {
    /**
     * In order to access private Buckets stored on AWS S3, this connector requires credentials with the proper permissions. If accessing publicly available data, this field is not necessary.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("aws_access_key_id")
    public String awsAccessKeyId;

    public SourceS3S3AmazonWebServices withAwsAccessKeyId(String awsAccessKeyId) {
        this.awsAccessKeyId = awsAccessKeyId;
        return this;
    }
    
    /**
     * In order to access private Buckets stored on AWS S3, this connector requires credentials with the proper permissions. If accessing publicly available data, this field is not necessary.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("aws_secret_access_key")
    public String awsSecretAccessKey;

    public SourceS3S3AmazonWebServices withAwsSecretAccessKey(String awsSecretAccessKey) {
        this.awsSecretAccessKey = awsSecretAccessKey;
        return this;
    }
    
    /**
     * Name of the S3 bucket where the file(s) exist.
     */
    @JsonProperty("bucket")
    public String bucket;

    public SourceS3S3AmazonWebServices withBucket(String bucket) {
        this.bucket = bucket;
        return this;
    }
    
    /**
     * Endpoint to an S3 compatible service. Leave empty to use AWS.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("endpoint")
    public String endpoint;

    public SourceS3S3AmazonWebServices withEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }
    
    /**
     * By providing a path-like prefix (e.g. myFolder/thisTable/) under which all the relevant files sit, we can optimize finding these in S3. This is optional but recommended if your bucket contains many folders/files which you don't need to replicate.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("path_prefix")
    public String pathPrefix;

    public SourceS3S3AmazonWebServices withPathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }
    
    /**
     * UTC date and time in the format 2017-01-25T00:00:00Z. Any file modified before this date will not be replicated.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceS3S3AmazonWebServices withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourceS3S3AmazonWebServices(@JsonProperty("bucket") String bucket) {
        this.bucket = bucket;
  }
}
