/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceSftpBulk - The values required to configure the source.
 */

public class SourceSftpBulk {
    /**
     * Sync only the most recent file for the configured folder path and file pattern
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_most_recent")
    public Boolean fileMostRecent;

    public SourceSftpBulk withFileMostRecent(Boolean fileMostRecent) {
        this.fileMostRecent = fileMostRecent;
        return this;
    }
    
    /**
     * The regular expression to specify files for sync in a chosen Folder Path
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_pattern")
    public String filePattern;

    public SourceSftpBulk withFilePattern(String filePattern) {
        this.filePattern = filePattern;
        return this;
    }
    
    /**
     * The file type you want to sync. Currently only 'csv' and 'json' files are supported.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("file_type")
    public SourceSftpBulkFileType fileType;

    public SourceSftpBulk withFileType(SourceSftpBulkFileType fileType) {
        this.fileType = fileType;
        return this;
    }
    
    /**
     * The directory to search files for sync
     */
    @JsonProperty("folder_path")
    public String folderPath;

    public SourceSftpBulk withFolderPath(String folderPath) {
        this.folderPath = folderPath;
        return this;
    }
    
    /**
     * The server host address
     */
    @JsonProperty("host")
    public String host;

    public SourceSftpBulk withHost(String host) {
        this.host = host;
        return this;
    }
    
    /**
     * OS-level password for logging into the jump server host
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("password")
    public String password;

    public SourceSftpBulk withPassword(String password) {
        this.password = password;
        return this;
    }
    
    /**
     * The server port
     */
    @JsonProperty("port")
    public Long port;

    public SourceSftpBulk withPort(Long port) {
        this.port = port;
        return this;
    }
    
    /**
     * The private key
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("private_key")
    public String privateKey;

    public SourceSftpBulk withPrivateKey(String privateKey) {
        this.privateKey = privateKey;
        return this;
    }
    
    /**
     * The separator used in the CSV files. Define None if you want to use the Sniffer functionality
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("separator")
    public String separator;

    public SourceSftpBulk withSeparator(String separator) {
        this.separator = separator;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceSftpBulkSftpBulk sourceType;

    public SourceSftpBulk withSourceType(SourceSftpBulkSftpBulk sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * The date from which you'd like to replicate data for all incremental streams, in the format YYYY-MM-DDT00:00:00Z. All data generated after this date will be replicated.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceSftpBulk withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    /**
     * The name of the stream or table you want to create
     */
    @JsonProperty("stream_name")
    public String streamName;

    public SourceSftpBulk withStreamName(String streamName) {
        this.streamName = streamName;
        return this;
    }
    
    /**
     * The server user
     */
    @JsonProperty("username")
    public String username;

    public SourceSftpBulk withUsername(String username) {
        this.username = username;
        return this;
    }
    
    public SourceSftpBulk(@JsonProperty("folder_path") String folderPath, @JsonProperty("host") String host, @JsonProperty("port") Long port, @JsonProperty("sourceType") SourceSftpBulkSftpBulk sourceType, @JsonProperty("start_date") OffsetDateTime startDate, @JsonProperty("stream_name") String streamName, @JsonProperty("username") String username) {
        this.folderPath = folderPath;
        this.host = host;
        this.port = port;
        this.sourceType = sourceType;
        this.startDate = startDate;
        this.streamName = streamName;
        this.username = username;
  }
}
