/* 
 * Code generated by Speakeasy (https://speakeasyapi.dev). DO NOT EDIT.
 */

package com.airbyte.api.models.shared;

import com.airbyte.api.utils.DateTimeDeserializer;
import com.airbyte.api.utils.DateTimeSerializer;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.OffsetDateTime;

/**
 * SourceStripe - The values required to configure the source.
 */

public class SourceStripe {
    /**
     * Your Stripe account ID (starts with 'acct_', find yours &lt;a href="https://dashboard.stripe.com/settings/account"&gt;here&lt;/a&gt;).
     */
    @JsonProperty("account_id")
    public String accountId;

    public SourceStripe withAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }
    
    /**
     * Stripe API key (usually starts with 'sk_live_'; find yours &lt;a href="https://dashboard.stripe.com/apikeys"&gt;here&lt;/a&gt;).
     */
    @JsonProperty("client_secret")
    public String clientSecret;

    public SourceStripe withClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }
    
    /**
     * When set, the connector will always re-export data from the past N days, where N is the value set here. This is useful if your data is frequently updated after creation. More info &lt;a href="https://docs.airbyte.com/integrations/sources/stripe#requirements"&gt;here&lt;/a&gt;
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("lookback_window_days")
    public Long lookbackWindowDays;

    public SourceStripe withLookbackWindowDays(Long lookbackWindowDays) {
        this.lookbackWindowDays = lookbackWindowDays;
        return this;
    }
    
    /**
     * The time increment used by the connector when requesting data from the Stripe API. The bigger the value is, the less requests will be made and faster the sync will be. On the other hand, the more seldom the state is persisted.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("slice_range")
    public Long sliceRange;

    public SourceStripe withSliceRange(Long sliceRange) {
        this.sliceRange = sliceRange;
        return this;
    }
    
    @JsonProperty("sourceType")
    public SourceStripeStripe sourceType;

    public SourceStripe withSourceType(SourceStripeStripe sourceType) {
        this.sourceType = sourceType;
        return this;
    }
    
    /**
     * UTC date and time in the format 2017-01-25T00:00:00Z. Only data generated after this date will be replicated.
     */
    @JsonSerialize(using = DateTimeSerializer.class)
    @JsonDeserialize(using = DateTimeDeserializer.class)
    @JsonProperty("start_date")
    public OffsetDateTime startDate;

    public SourceStripe withStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }
    
    public SourceStripe(@JsonProperty("account_id") String accountId, @JsonProperty("client_secret") String clientSecret, @JsonProperty("sourceType") SourceStripeStripe sourceType, @JsonProperty("start_date") OffsetDateTime startDate) {
        this.accountId = accountId;
        this.clientSecret = clientSecret;
        this.sourceType = sourceType;
        this.startDate = startDate;
  }
}
